; TESTMEM.ASM
;
; This program tests RAM on the Memory Plus Expansion card on the 1000HX.
; This card has either 128k RAM or 384k RAM onboard, in either case
; starting at 0.  Memory is saved and tested 16 bytes (1 paragraph) at a
; time, using various bit patterns.
;
; This is part 2 of a 2-part program:  This part is loaded at either 20000h
; or 60000h, depending on how much RAM is detected by part 1, the loader
; program - the idea being to load this program into the "safe" motherboard
; RAM.
;

		ORG	0
		JMP	START
;
; Data.
;
STARTSEG	DW	?		; start of "fade" test
STOPSEG		DW	?		; code segment = where to stop test
CURSEG		DW	0		; 16-byte paragraph being tested
PAT1		EQU	00000h		; test patterns
PAT2		EQU	05555h
PAT3		EQU	0AAAAh
PAT4		EQU	0FFFFh
PAT1B		EQU	000h
PAT2B		EQU	055h
PAT3B		EQU	0AAh
PAT4B		EQU	0FFh
SAVEBUF		DB	16 DUP (?)
ERRFOUND	DB	0
ERRREAD		DB	?
ERRWRIT		DB	?
ERRADDR		DW	?
BASICSTR	DB	"PATTERN TEST"
BASICSTR_LEN	EQU	$-OFFSET BASICSTR
BASICSTR_COLOR	DB	06h
BASICSTR_ROW	DB	0
BASICSTR_COLUMN	DB	0
TESTING		DB	"Testing segment: "
TESTING_LEN	EQU	$-OFFSET TESTING
TESTING_COLOR	DB	02h
TESTING_ROW	DB	2
TESTING_COLUMN	DB	3
CURSEG_STR	DB	"    "
PERRSTR		DB	"Error at "
PERRLOC		DB	5 DUP ?
		DB	": wrote "
PERRWRIT	DB	2 DUP ?
		DB	", read "
PERRREAD	DB	2 DUP ?
PERRSTR_LEN	EQU	$-OFFSET PERRSTR
PERRSTR_COLOR	DB	04h
PERRSTR_ROW	DB	3
PERRSTR_COLUMN	DB	3
DMATSTR		DB	"DMA TEST"
DMATSTR_LEN	EQU	$-OFFSET DMATSTR
DMATSTR_COLOR	DB	06h
DMATSTR_ROW	DB	5
DMATSTR_COLUMN	DB	0
DMAPSTR		DB	"DMA chip passed basic test."
DMAPSTR_LEN	EQU	$-OFFSET DMAPSTR
DMAPSTR_COLOR	DB	02h
DMAPSTR_ROW	DB	7
DMAPSTR_COLUMN	DB	3
DMAFSTR		DB	"DMA chip failed basic test."
DMAFSTR_LEN	EQU	$-OFFSET DMAFSTR
DMAFSTR_COLOR	DB	04h
DMAFSTR_ROW	DB	7
DMAFSTR_COLUMN	DB	3
RETENSTR	DB	"RETENTION TEST"
RETENSTR_LEN	EQU	$-OFFSET RETENSTR
RETENSTR_COLOR	DB	06h
RETENSTR_ROW	DB	10
RETENSTR_COLUMN	DB	0
RTESTING	DB	"Pattern "
RTESTING_PAT	DB	4 DUP ?
RTESTING_LEN	EQU	$-OFFSET RTESTING
RTESTING_COLOR	DB	02h
RTESTING_ROW	DB	12
RTESTING_COLUMN	DB	3
RERRSTR		DB	"Error at "
RERRLOC		DB	5 DUP ?
		DB	": wrote "
RERRWRIT	DB	2 DUP ?
		DB	", read "
RERRREAD	DB	2 DUP ?
RERRSTR_LEN	EQU	$-OFFSET RERRSTR
RERRSTR_COLOR	DB	04h
RERRSTR_ROW	DB	13
RERRSTR_COLUMN	DB	3
FINSTR1		DB	"Tests finished, card OK.  Turn machine"
FINSTR1_LEN	EQU	$-OFFSET FINSTR1
FINSTR2		DB	"off or reboot."
FINSTR2_LEN	EQU	$-OFFSET FINSTR2
FINSTR_COLOR	DB	07h
FINSTR_ROW	DB	16
FINSTR_COLUMN	DB	0

;
; Code.
;
START:
	CLD
	MOV	STOPSEG,CS
	CALL	CLEARSCR
	XOR	AX,AX
MAINLOOP:
	MOV	CURSEG,AX
	CALL	SHOWCUR
	CALL	TEST16
	MOV	AX,CURSEG
	INC	AX
	CMP	AX,STOPSEG
	JB	MAINLOOP
	;
	; DMA controller test.
	;
	LEA	SI,DMATSTR
	MOV	CX,DMATSTR_LEN
	MOV	BH,DMATSTR_COLOR
	MOV	AL,DMATSTR_ROW
	MOV	BL,DMATSTR_COLUMN
	CALL	SHOWSTR
	CALL	TESTDMA
	LEA	SI,DMAPSTR
	MOV	CX,DMAPSTR_LEN
	MOV	BH,DMAPSTR_COLOR
	MOV	AL,DMAPSTR_ROW
	MOV	BL,DMAPSTR_COLUMN
	CALL	SHOWSTR
	;
	; Retention test.
	;
	LEA	SI,RETENSTR
	MOV	CX,RETENSTR_LEN
	MOV	BH,RETENSTR_COLOR
	MOV	AL,RETENSTR_ROW
	MOV	BL,RETENSTR_COLUMN
	CALL	SHOWSTR
	MOV	AX,PAT1
	CALL	SHOWPAT
	CALL	FILLMEM
	CALL	DELAY
	MOV	AL,PAT1B
	CALL	CHKPAT
	MOV	AX,PAT2
	CALL	SHOWPAT
	CALL	FILLMEM
	CALL	DELAY
	MOV	AL,PAT2B
	CALL	CHKPAT
	MOV	AX,PAT3
	CALL	SHOWPAT
	CALL	FILLMEM
	CALL	DELAY
	MOV	AL,PAT3B
	CALL	CHKPAT
	MOV	AX,PAT4
	CALL	SHOWPAT
	CALL	FILLMEM
	CALL	DELAY
	MOV	AL,PAT4B
	CALL	CHKPAT
	LEA	SI,FINSTR1
	MOV	CX,FINSTR1_LEN
	MOV	BH,FINSTR_COLOR
	MOV	AL,FINSTR_ROW
	MOV	BL,FINSTR_COLUMN
	CALL	SHOWSTR
	LEA	SI,FINSTR2
	MOV	CX,FINSTR2_LEN
	INC	AL
	CALL	SHOWSTR
	JMP	$

;
; Test DMA count and address registers.
;
TESTDMA:
	PUSH	AX
	PUSH	CX
	PUSH	DX
	CLI
	MOV	AL,70h		; disable timer channel 1: counter 1, lsb then
	OUT	43h,AL		;   msb, interrupt on TC, binary
	JMP	$+2
	MOV	AL,0		; set counter to 0
	OUT	41h,AL
	JMP	$+2
	OUT	41h,AL
	JMP	$+2
	OUT	0Dh,AL		; master reset of DMA
	JMP	$+2
	MOV	AL,4		; disable controller
	OUT	08h,AL
	JMP	$+2
	MOV	CX,1		; for each bit 0-15:
	XOR	DX,DX		;   for each DMA register 0-7:
TESTDMA_L:
	MOV	AL,CL           ;     write value to register
	OUT	DX,AL
	JMP	$+2
	MOV	AL,CH
	OUT	DX,AL
	JMP	$+2
	IN	AL,DX		;     read back
	JMP	$+2
	CMP	AL,CL
	JNE	TESTDMA_E	;     error if read <> written
	IN	AL,DX
	JMP	$+2
	CMP	AL,CH
	JNE	TESTDMA_E
	INC	DX		;     (next register)
	CMP	DX,8
	JB	TESTDMA_L
	MOV	DX,0
	RCL	CX,1		;   (next bit)
	JNC	TESTDMA_L
	JMP	TESTDMA_C
TESTDMA_E:
	MOV	ERRFOUND,1
TESTDMA_C:
	XOR	AL,AL		; reprogram RAM refresh - clear page registers
	OUT	81h,AL
	JMP	$+2
	OUT	82h,AL
	JMP	$+2
	OUT	83h,AL
	JMP	$+2
	OUT	0Dh,AL		; master reset of DMA
	JMP	$+2
	MOV	AL,4		; disable controller
	OUT	08h,AL
	JMP	$+2
	XOR	DX,DX		; clear DMA count and address registers
	XOR	AL,AL
TESTDMA_M:
	OUT	DX,AL
	JMP	$+2
	OUT	DX,AL
	JMP	$+2
	INC	DX
	CMP	DX,8
	JNE	TESTDMA_M
	MOV	AL,58h		; DMA channel 0: single mode, address
	OUT	0Bh,AL		;   increment, autoinitialize, read transfer
	JMP	$+2
	MOV	AL,49h		; DMA channel 1: single mode, address
	OUT	0Bh,AL		;   increment, no autoinitialize, read transfer
	JMP	$+2
	MOV	AL,4Ah		; DMA channel 2: single mode, address
	OUT	0Bh,AL		;   increment, no autoinitialize, read transfer
	JMP	$+2
	MOV	AL,0Eh		; mask/disable all but channel 0
	OUT	0Fh,AL
	JMP	$+2
	MOV	AL,0FFh		; DMA channel 0 count = 0FFh = 255 (actually
	OUT	01h,AL		;   256)
	JMP	$+2
	MOV	AL,0		; memory-to-memory disable, controller enable,
	OUT	08h,AL		;   normal timing, fixed priority, late write,
	JMP	$+2		;   DREQ hi, DACK low
	MOV	AL,74h		; PIT counter 1, lsb then msb, rate generator,
	OUT	43h,AL		;   binary
	JMP	$+2
	MOV	AL,12h		; count = 12h (normal refresh rate)
	OUT	41h,AL
	JMP	$+2
	XOR	AL,AL
	OUT	41h,AL
	JMP	$+2
	STI
	POP	DX
	POP	CX
	POP	AX
	CMP	ERRFOUND,1
	JE	DMAERR
	RET

;
; DMA test failed.
;
DMAERR:
	LEA	SI,DMAFSTR
	MOV	CX,DMAFSTR_LEN
	MOV	BH,DMAFSTR_COLOR
	MOV	AL,DMAFSTR_ROW
	MOV	BL,DMAFSTR_COLUMN
	CALL	SHOWSTR
	JMP	$

;
; Short delay.
;
DELAY:
	PUSH	CX
	MOV	CX,100
DELAY_L:
	PUSH	CX
	XOR	CX,CX
	LOOP	$
	POP	CX
	LOOP	DELAY_L
	POP	CX
	RET

;
; Display pattern in AX.
;
SHOWPAT:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	MOV	BX,AX
	LEA	DI,RTESTING_PAT
	CLD
	MOV	AL,BH
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BH
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	SI,RTESTING
	MOV	CX,RTESTING_LEN
	MOV	BH,RTESTING_COLOR
	MOV	AL,RTESTING_ROW
	MOV	BL,RTESTING_COLUMN
	CALL	SHOWSTR
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Fill memory from STARTSEG to STOPSEG with the pattern in AX.
;
FILLMEM:
	PUSH	ES
	PUSH	DI
	PUSH	CX
	PUSH	BX
	MOV	BX,STARTSEG
FILLMEM_LOOP:
	MOV	ES,BX
	XOR	DI,DI
	MOV	CX,8
	REP	STOSW
	INC	BX
	CMP	BX,STOPSEG
	JB	FILLMEM_LOOP
	POP	BX
	POP	CX
	POP	DI
	POP	ES
	RET

;
; Test whether memory filled with a pattern is still filled with the same
; pattern (in AL).
;
CHKPAT:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DS
	MOV	BX,STARTSEG
	MOV	CURSEG,BX
	MOV	AH,AL
CHKPAT_L1:
	MOV	DS,BX
	XOR	SI,SI
	MOV	CX,16
CHKPAT_L2:
	LODSB
	CMP	AL,AH
	JE	CHKPAT_L2A
	JMP	RERROR
CHKPAT_L2A:
	LOOP	CHKPAT_L2
	INC	BX
	MOV	CS:CURSEG,BX
	CMP	BX,CS:STOPSEG
	JB	CHKPAT_L1
	POP	DS
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Jump to here in case of error in the retention test.
;
RERROR:
	MOV	CS:ERRREAD,AL
	MOV	CS:ERRWRIT,AH
	DEC	SI
	MOV	CS:ERRADDR,SI
	POP	DS
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	MOV	ERRFOUND,1
	LEA	DI,RERRLOC
	CLD
	MOV	AL,BYTE PTR CURSEG+1
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG+1
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR ERRADDR
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	DI,RERRWRIT
	MOV	AL,ERRWRIT
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,ERRWRIT
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	DI,RERRREAD
	MOV	AL,ERRREAD
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,ERRREAD
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	SI,RERRSTR
	MOV	CX,RERRSTR_LEN
	MOV	BH,RERRSTR_COLOR
	MOV	AL,RERRSTR_ROW
	MOV	BL,RERRSTR_COLUMN
	CALL	SHOWSTR
	JMP	$

;
; Test a 16-byte segment.  ES=DS=segment to test.
;
TEST16:
	PUSH	AX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	CLD
	MOV	ERRFOUND,0
	CLI			; test with interrupts off - may test vector
	MOV	DS,CURSEG	;   table
	XOR	SI,SI		; save data
	LEA	DI,SAVEBUF
	MOV	CX,8
	REP	MOVSW
	MOV	ES,CS:CURSEG	; fill with pattern 1
	XOR	DI,DI
	MOV	CX,8
	MOV	AX,PAT1
	REP	STOSW
	XOR	SI,SI
	MOV	CX,16
	MOV	AH,PAT1B
TESTPAT1:
	LODSB
	CMP	AL,AH
	JE	TESTPAT1L
	JMP	TESTERR
TESTPAT1L:
	LOOP	TESTPAT1
	XOR	DI,DI
	MOV	CX,8
	MOV	AX,PAT2
	REP	STOSW
	XOR	SI,SI
	MOV	CX,16
	MOV	AH,PAT2B
TESTPAT2:
	LODSB
	CMP	AL,AH
	JE	TESTPAT2L
	JMP	TESTERR
TESTPAT2L:
	LOOP	TESTPAT2
	XOR	DI,DI
	MOV	CX,8
	MOV	AX,PAT3
	REP	STOSW
	XOR	SI,SI
	MOV	CX,16
	MOV	AH,PAT3B
TESTPAT3:
	LODSB
	CMP	AL,AH
	JE	TESTPAT3L
	JMP	TESTERR
TESTPAT3L:
	LOOP	TESTPAT3
	XOR	DI,DI
	MOV	CX,8
	MOV	AX,PAT4
	REP	STOSW
	XOR	SI,SI
	MOV	CX,16
	MOV	AH,PAT4B
TESTPAT4:
	LODSB
	CMP	AL,AH
	JE	TESTPAT4L
	JMP	TESTERR
TESTPAT4L:
	LOOP	TESTPAT4
	XOR	SI,SI
	MOV	CX,16
	MOV	AX,00FFh	; AH=0, AL=FF
TESTPAT5:
	MOV	[SI],AL		; set to all 1
	MOV	[SI],AH		; set to all 0
	LODSB
	CMP	AL,AH
	JE	TESTPAT5L
	JMP	TESTERR
TESTPAT5L:
	LOOP	TESTPAT5
	XOR	SI,SI
	MOV	CX,16
	MOV	AX,0FF00h	; AH=FF, AL=0
TESTPAT6:
	MOV	[SI],AL		; set to all 0
	MOV	[SI],AH		; set to all 1
	LODSB
	CMP	AL,AH
	JE	TESTPAT6L
	JMP	TESTERR
TESTPAT6L:
	LOOP	TESTPAT6
	MOV	AX,CS		; restore data
	MOV	DS,AX
	LEA	SI,SAVEBUF
	XOR	DI,DI
	MOV	CX,8
	REP	MOVSW
	STI
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	CX
	POP	AX
	RET

	;
	; Go to here in case of error.
	;
TESTERR:
	MOV	CS:ERRREAD,AL
	MOV	CS:ERRWRIT,AH
	DEC	SI
	MOV	CS:ERRADDR,SI
	MOV	AX,CS		; restore data
	MOV	DS,AX
	LEA	SI,SAVEBUF
	XOR	DI,DI
	MOV	CX,8
	REP	MOVSW
	STI
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	CX
	POP	AX
	MOV	ERRFOUND,1
	LEA	DI,PERRLOC
	CLD
	MOV	AL,BYTE PTR CURSEG+1
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG+1
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR ERRADDR
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	DI,PERRWRIT
	MOV	AL,ERRWRIT
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,ERRWRIT
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	DI,PERRREAD
	MOV	AL,ERRREAD
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,ERRREAD
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	SI,PERRSTR
	MOV	CX,PERRSTR_LEN
	MOV	BH,PERRSTR_COLOR
	MOV	AL,PERRSTR_ROW
	MOV	BL,PERRSTR_COLUMN
	CALL	SHOWSTR
	JMP	$

;
; Clear the screen, set to 40x25 color text, and display invariant strings.
;
CLEARSCR:		
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	MOV	AX,1			; select 40-column color text
	INT	10h
	MOV	AH,1			; erase cursor
	MOV	CH,20h
	INT	10h
	LEA	SI,BASICSTR
	MOV	CX,BASICSTR_LEN
	MOV	BH,BASICSTR_COLOR
	MOV	AL,BASICSTR_ROW
	MOV	BL,BASICSTR_COLUMN
	CALL	SHOWSTR
	LEA	SI,TESTING
	MOV	CX,TESTING_LEN
	MOV	BH,TESTING_COLOR
	MOV	AL,TESTING_ROW
	MOV	BL,TESTING_COLUMN
	CALL	SHOWSTR
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Display the segment currently being tested (=CURSEG) on the screen.
;
SHOWCUR:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	LEA	DI,CURSEG_STR
	CLD
	MOV	AL,BYTE PTR CURSEG+1
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG+1
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BYTE PTR CURSEG
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	SI,CURSEG_STR
	MOV	CX,4
	MOV	BH,2
	MOV	AL,TESTING_ROW
	MOV	BL,TESTING_COLUMN
	ADD	BL,TESTING_LEN
	CALL	SHOWSTR
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Display the pattern currently being tested (in AX) on the screen.
;
SHOWPAT2:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	MOV	BX,AX
	LEA	DI,RTESTING_PAT
	CLD
	MOV	AL,BH
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BH
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	LEA	SI,RTESTING_PAT
	MOV	CX,4
	MOV	BH,DMAPSTR_COLOR
	MOV	AL,DMAPSTR_ROW
	MOV	BL,DMAPSTR_COLUMN
	ADD	BL,DMAPSTR_LEN
	CALL	SHOWSTR
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET

;
; On entry, AL=value 0-15.  On exit, AL=hex character.
;
HEXCHAR:
	CMP	AL,10
	JAE	HEXCHAR_LTR
	ADD	AL,30h
	JMP	HEXCHAR_END
HEXCHAR_LTR:
	ADD	AL,41h-10
HEXCHAR_END:
	RET

;
; Display some text on the screen.  On entry, SI->string to display, CX=
; length of string, BH=attribute, AL=row, BL=column.
;
SHOWSTR:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	MOV	DX,0B800h	; ES->video buffer
	MOV	ES,DX
	MOV	AH,80		; 40 columns x 2 bytes per = 80 bytes/col.
	MUL	AH		; AX = starting address of row
	SHL	BL,1		; multiply column by 2
	ADD	AL,BL		; add to row address to get where string starts
	ADC	AH,0
	MOV	DI,AX		; ES:DI->where to put string w/attributes
	CLD
SHOWSTR_L:
	MOVSB			; save character
	MOV	ES:[DI],BH	; save attribute
	INC	DI
	LOOP	SHOWSTR_L	; loop if more characters
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
