#ifndef ACTOR.H

#define ACTOR.H

#include "animicon.h"
#include "animap.h"
#include "script.h"

#define MAX_ICONS 20

class event;

class animactor : public animslave, public script
{
public:
  byte myIconNumber;  // what do we look like?
  byte myIdentity;	// ...and what ARE we?
  word mapX, mapY; //position on parent map
  int lastMapX, lastMapY;
  byte squareX, squareY; //position on map square, so we can move finely
  animactor * nextActor;
  animactor * spawningActor;
  animactor * spawnedActor;
  animap * mymap;
  static animicon * actorIcons;
  animactor() : animslave() {nextActor = spawnedActor = spawningActor = NULL; mymap = NULL; mapX = mapY = squareX = squareY = myIconNumber = 0;}
  virtual void * isInSquare(byte identity);
  void put(int x, int y);
  void remove(void);
  void fineMoveRel(int x, int y);
  void moveTo(int x, int y);
  int hit(animactor * target);
  virtual void advance();
  virtual void show(int x, int y, word pagebase);
  virtual void draw(int x, int y, word pagebase);
  virtual void spawn(animactor * spawnactor);
  virtual void assignIcon(byte iconNumber, byte identity = 255);
  virtual void turn(byte idirection) {};
  static void loadActor(int position, char far * filename, yakLib * myYakLib = NULL);
};

#endif