#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include "xlib.h"
#include "xrect.h"
#include "icon.h"
#include "animicon.h"
#include "yakFont.h"
#include "yakMouse.h"
#include "yakPal.h"

extern yakMouse mouse;

class star
{
public:
  int x, y, xIncrement, yIncrement, size;
  void initialize(void) {x = 100 + random(100); y = 60 + random(60); size = 5;};
  void advance(void);
  star(void) {initialize();};
};

void star::advance(void)
{
  xIncrement = (x - 150)/5;
  yIncrement = (y-100)/5;
  x+=xIncrement;
  y+=yIncrement;
  size++;
  if ((x < 0) || (x+size > 320)) initialize();
  if ((y < 0) || (y+size > 200)) initialize();
};
void main(void)
{
  randomize();
  yakLib myYakLib("draw");
  icon starIcon, shipIcon;
  icon::setZoomTable(64);
  x_set_mode(2,360);
  x_set_doublebuffer(200);
  x_text_init();
  mouse.init();
  yakPalette myYakPalette("standard.ypl");
  myYakPalette.put();
  starIcon.load("star.yak", icon::normal, &myYakLib);
  shipIcon.load("awayship.yak", icon::normal, &myYakLib);
  int x, y, exit = 0;
  int scale=200;
  x = 50;
  star stars[10];
  while ((exit != 'Q') && (scale > 0))
  {
    x_rect_fill(0,0,320,200,HiddenPageOffs,0);
    for (int starCounter = 0; starCounter < 10; ++starCounter)
    {
      stars[starCounter].advance();
      starIcon.showZoomed(stars[starCounter].x, stars[starCounter].y, HiddenPageOffs, stars[starCounter].size);
    }
    scale-=4;
    x += 2;
    if (scale > 1)
      shipIcon.showZoomed(x, 20, HiddenPageOffs, scale);

    x_page_flip(0,0);
  }
  for (int counter = 0; counter < 25; ++counter)
  {
    myYakPalette.fade(-5);
    myYakPalette.put();
  }
  x_text_mode();
}