
#include "gadgets.h"
#include "xlib.h"
#include "xrect.h"
#include "xline.h"
#include "xpoint.h"
#include "xtext.h"

#include <string.h>
#include <conio.h>
extern yakMouse mouse;

gadget::gadget(char icommandChar, char * filename, icon::flagType aflags, yakLib * myYakLib, gadget::flagType iflags, int ix, int iy):
  animicon(filename, aflags, myYakLib)
{
  commandChar = icommandChar;
  flags = iflags;
  relX = ix;
  relY = iy;
}

gadget::gadget(char icommandChar, animiconNode * thisFrame, gadget::flagType iflags, int ix, int iy) :
  animicon()
{
  commandChar = icommandChar;
  flags = iflags;
  relX = ix;
  relY = iy;
  animicon::add(thisFrame);
}

byte gadget::isSelected(void) //0 if not; 1 if yes, 2 if selected for help.
{
  int mousex = mouse.x(), mousey = mouse.y(); //to reduce # of function calls;
  if (mouse.isInBox(x, y, x+thisFrame->picture.width, y+thisFrame->picture.height))
  {
    if (((flags & touchPad) ? mouse.isPressed(yakMouse::leftButton) : mouse.isClicked(yakMouse::leftButton))
       &&(x_get_pix(mousex, mousey, VisiblePageOffs) == thisFrame->picture.getPixel(mousex - x, mousey - y))
       &&(x_get_pix(mousex, mousey, VisiblePageOffs) != 0))
        return 1;
    else if (mouse.isPressed(yakMouse::rightButton))
        return 2;
  }
  else if (kbhit())
  {
    char tempchar = getch();
    if (tempchar == commandChar)
      return 1;
    else
    {
      ungetch(tempchar);
      return 0;
    }
  }
  return 0;
}
//button functions follow------------------------------------->

button::button(int ix, int iy, char commandChar, int returnValue, char * filename, icon::flagType flags, yakLib * myYakLib, gadget::flagType iflags) :
  gadget(commandChar, filename, flags, myYakLib, iflags, ix, iy),
  returnValue(returnValue) {type = buttonType;}


int button::status(void)
{
  byte isSel = isSelected();
  return (isSel) ? ((isSel == 1) ? returnValue : (returnValue | HELP_MASK)) : 0;
}

int button::activate(void)
{
  return 0;
}
//label functions follow------------------------------------->
label::label(int ix, int iy, char commandChar, int returnValue, char * text, byte ifgColor, byte ibgColor, gadget::flagType iflags) :
  button(ix, iy, commandChar, returnValue, "", icon::normal, NULL, iflags),
  myText(text),
  fgColor(ifgColor),
  bgColor(ibgColor) {type = buttonType;}

void label::draw(int ix, int iy, word offset)
{
  x = ix;
  y = iy;
  x_bgprintf(x, y, offset, fgColor, bgColor, myText);
}

byte label::isSelected(void)
{
  if (mouse.isInBox(x, y, x+strlen(myText)*CharWidth, y+CharHeight))
  {
    if ((flags & touchPad) ? mouse.isPressed(yakMouse::leftButton) : mouse.isClicked(yakMouse::leftButton))
      return 1;
    else if (mouse.isPressed(yakMouse::rightButton))
      return 2;
  }
  else if (kbhit())
  {
    char tempchar = getch();
    if (tempchar == commandChar)
      return 1;
    else
    {
      ungetch(tempchar);
      return 0;
    }
  }
  return 0;
}


//pSwitch functions follow----------------------------------->

pSwitch::pSwitch(int ix, int iy, char commandChar, char * filename, icon::flagType flags, yakLib * myYakLib, gadget::flagType iflags) :
  gadget(commandChar, filename, flags, myYakLib, iflags, ix, iy),
  position(0) {type = pSwitchType;}

int pSwitch::activate(void)
{
  position = (position == (numberOfFrames - 1)) ? 0 : (position + 1);
  animicon::advance();
  mouse.hide();
  draw(x,y,VisiblePageOffs);
  mouse.show();
  return position;
}

int pSwitch::status(void)
{
  if(isSelected())
    activate();
  return position;
}

//slider functions follow-------------------------------------->


slider::slider(int ix, int iy, int iwidth, int iheight, int iminimumValue, int imaximumValue, byte ibarColor, byte iborderColor, byte iindicatorColor) :
gadget()
{
  relX = ix;
  relY = iy;
  width = iwidth;
  height = iheight;
  minimumValue = iminimumValue;
  maximumValue = imaximumValue;
  barColor = ibarColor;
  borderColor = iborderColor;
  position = (width / 2);
  indicatorColor = iindicatorColor;
  type = sliderType;
}

void slider::draw(int ix, int iy, word offset)
{
  x = ix;
  y = iy;
  x_rect_fill(x, y, x+width, y+height, offset, borderColor); //yer basic bar
  x_line(x,y, x+width, y, borderColor + 5, offset); //top
  x_line(x,y, x, y+height-1, borderColor + 5, offset); //left
  x_line(x,y+height-1, x+width-1, y+height-1, borderColor - 5, offset); //bottom
  x_line(x+width,y, x+width, y+height-1, borderColor - 5, offset); //right
  x_rect_fill(x+2, y+2, x+width-2, y+height-2, offset, barColor);
  x_rect_fill(x + 2, y+2, x + position + 3, y+height -2, VisiblePageOffs, indicatorColor);
}

void slider::draw(word offset)
{
  draw(x, y, offset);
}

int slider::status(void)
{
  return(activate());
}

int slider::activate(void)
{
  if ((mouse.isInBox(x, y, x+width, y+height))
     &&(mouse.isPressed(yakMouse::leftButton)))
  {
    mouse.hide();
    x_rect_fill(x+2, y+2, x+width-2, y+height-2, VisiblePageOffs, barColor);
    x_rect_fill(x + 2, y+2, x + position + 3, y+height -2, VisiblePageOffs, indicatorColor);
    position = mouse.x() - x - 1;
    if (position < 0)
      position = 0;
    if (position > width - 5)
      position = (width - 5);
  mouse.show();
  }
  return (minimumValue + ((float)position/(float)(width - 5))*((float)(maximumValue - minimumValue)));
}



//list functions follow---------------------------------------------->
void gadgetList::draw(int ix, int iy, word offset)
{
  for (gadgetNode * thisGadget = firstGadget; thisGadget != NULL; thisGadget = thisGadget->nextGadget)
    thisGadget->thisGadget->draw(ix + thisGadget->thisGadget->relX, iy + thisGadget->thisGadget->relY, offset);
}

void gadgetList::draw(word offset)
{
  for (gadgetNode * thisGadget = firstGadget; thisGadget != NULL; thisGadget = thisGadget->nextGadget)
    thisGadget->thisGadget->draw(offset);
}

int gadgetList::status(void)
{
  int returnValue = 0;
  int oldValue = 0;
  for (gadgetNode * thisGadget = firstGadget; ((thisGadget != NULL) && (!returnValue)); thisGadget = thisGadget->nextGadget)
  {
    if (thisGadget->thisGadget->type == gadget::buttonType)
      oldValue = thisGadget->thisGadget->status();
    else
      thisGadget->thisGadget->status();
    if (oldValue)
      returnValue = oldValue;
  }
  if (!(mouse.isPressed(yakMouse::eitherButton)))
    mouse.isClicked(yakMouse::reset);

  return returnValue;
}

void gadgetList::add(gadgetNode * theNewGadget)
{
  if (firstGadget != NULL)
  {
    lastGadget->nextGadget = theNewGadget; // make the new node
    lastGadget->nextGadget->prevGadget = lastGadget; //make new node point back
    firstGadget->prevGadget = lastGadget;
    lastGadget = lastGadget->nextGadget;
  }
  else
  {
    firstGadget = theNewGadget; // make the new node
    lastGadget = firstGadget;
    lastGadget->prevGadget = firstGadget; //make new node point back
    firstGadget->prevGadget = lastGadget; //so it wraps backwards too.
  }
  if (lastGadget->nextGadget)
    add(lastGadget->nextGadget);
  else
    lastGadget->nextGadget = NULL;
}

