#define YAKKEYSUNIT
#include "yakkeys.h"
#include <dos.h>
#include <mem.h>
#include <stdlib.h>

yakKeyboard keyboard;

char yakKeyboard::keys[128];
void interrupt (*yakKeyboard::oldHandler)(...) = NULL;

void interrupt yakKeyboard::newHandler(...)
{
  static word * bufferTail, *bufferHead;
  byte keyCode = inp(0x60);
  if (keyCode & 0x80)
    keys[keyCode & 0x7F] = 0;
  else
  {
    keys[keyCode] = 1;
  }
  bufferTail = (word *)MK_FP(0x40, 0x1A);
  bufferHead = (word *)MK_FP(0x40, 0x1C);
  *bufferTail = *bufferHead;
  oldHandler();
}

void yakKeyboard::install(void)
{
  static int firstTime = 1;
  oldHandler = getvect(9);
  memset(keys, 0, sizeof(keys));
  setvect(9, &yakKeyboard::newHandler)
  ;
  if (firstTime)
  {
    atexit((void (*)())&(yakKeyboard::remove));
    firstTime = 0;
  }
}

void yakKeyboard::remove(void)
{
  setvect(9, oldHandler);
}
