/* --------------------------------- colors.h ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* colors definition.
*/

#define RGB(r,g,b)	(((0x0ffL&(b))<<16)+((0x0ffL&(g))<<8)+(0x0ffL&(r)))
 
#define C_BLACK		RGB (0x00, 0x00, 0x00)

#define C_RED		RGB (0xff, 0x00, 0x00)
#define C_GREEN		RGB (0x00, 0xff, 0x00)
#define C_BLUE		RGB (0x00, 0x00, 0xff)

#define C_CYAN		RGB (0x00, 0xff, 0xff)
#define C_MAGENTA	RGB (0xff, 0x00, 0xff)
#define C_YELLOW	RGB (0xff, 0xff, 0x00)

#define C_WHITE		RGB (0xff, 0xff, 0xff)
#define C_LIGHTGRAY	RGB (0xa0, 0xa0, 0xa0)
#define C_GRAY		RGB (0x60, 0x60, 0x60)

#define C_LIGHTRED	RGB (0xc0, 0x60, 0x60)
#define C_LIGHTGREEN	RGB (0x80, 0xff, 0x80)
#define C_LIGHTBLUE	RGB (0x80, 0x80, 0xff)

#define C_LIGHTCYAN	RGB (0x80, 0xff, 0xff)
#define C_LIGHTMAGENTA	RGB (0xff, 0x80, 0xff)

#define C_LYELLOW	RGB (0x80, 0x80, 0x00)
#define C_SKYBLUE	RGB (0x00, 0x00, 0x80)

#define C_BROWN		RGB (0x80, 0x40, 0x00)
