/* --------------------------------- fly8.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* 'fly8' was the name of the last version written back in '74 at the
 * Technion with Danny. It ran on a PDP-15 with a VT15 stroke graphics
 * device at the EE digital lab. Assembley, no color, sound supplied by
 * the mechanical console teletype shaking it's head and ringing it's bell.
 * Those were the days (come to think of it, mostly NIGHTS!).
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "fly.h"

struct status	st = {0};

#define	STACK_CHAR ((Uchar)0x5a)

static int FAR
check_stack (int func)		/* 0=set, 1=check */
{
	Uchar		chunk[3800], *p;

	if (func == 0) {
		for (p = chunk; p < &chunk[sizeof (chunk)]; *p++ = STACK_CHAR);
		return (0);
	}

/* If the first bytes of chunk[] are untouched then we assume that the stack
 * grown to lower addresses (so chunk[] was used from its end).
*/
	for (p = &chunk[16]; --p > chunk && *p == STACK_CHAR;)
		;

	if (p > chunk) {			/* head was used */
		for (p = &chunk[sizeof (chunk)]; p > chunk;)
			if (*--p != STACK_CHAR)
				return (p - chunk);
	} else {				/* tail was used */
		for (p = chunk; p < &chunk[sizeof (chunk)];)
			if (*p++ != STACK_CHAR)
				return (sizeof (chunk) - (p - chunk));
	}

	return (0);
}

extern int
C_MAIN (int argc, char *argv[])
{
	int	n;

	check_stack (0);

	initialize (argv+1);

	show_fixed (0);			/* show fixed screen contents */

	user_command ();		/* let them have the controls */

	n = check_stack (1);
	terminate (n);

	exit (0);
	return (0);			/* avoid compiler warning */
}
