/* --------------------------------- console.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Console keyboard handler: Microsoft WINDOWS
*/

#include <windows.h>

#include "fly.h"

extern HWND   ghWndMain, ghWndText;
extern RECT   rect;
extern HDC hdc, texthdc;
extern HPALETTE hpal;
static MSG msg;
static int key = -1;
static int pressed = 0;

static int FAR
kread (void)
{
        int c = -1;
/*char xx[80];*/

        if (pressed) {
		c = key;
/*sprintf (xx, "%02.02X %d %c", key, key, key);
MessageBox (ghWndMain, xx, "Key Pressed", MB_OK);*/
                pressed = 0;
        }
        
        if (PeekMessage (&msg, ghWndMain, 0, 0, PM_REMOVE)) {
		if (msg.message == WM_QUIT)
        		c = -1;
	        TranslateMessage ( (LPMSG)&msg );
        	DispatchMessage ( (LPMSG)&msg );
        }
        
        /* remove messages for the other Text and printf (console) windows */
	if (PeekMessage (&msg, ghWndText,   0, 0, PM_REMOVE)) {
	        TranslateMessage ( (LPMSG)&msg );
        	DispatchMessage ( (LPMSG)&msg );
        }
	        
	return (c);

}

static int FAR
kwait (void)
{
        MSG msg;
        int esc, c = 0;

   	/* Polling messages from event queue */
   	GetMessage((LPMSG)&msg, ghWndMain, 0, 0);
      	TranslateMessage ((LPMSG)&msg);
      	DispatchMessage ((LPMSG)&msg);
      	
	for (esc = 0; -1 != c; c = kread ())
		if (K_ESC == c)
			esc = 1;
	return (esc);
}

static int FAR
kgetch (void)
{
	int	c;

	while ((c = kread ()) == -1)
		sys_poll ();
	return (c);
}

static int FAR
kinit (void)
{
	return (0);
}

static void FAR
kterm (void)
{
}

struct KbdDriver KbdConsole = {
	"CONSOLE",
	0,
	kinit,
	kterm,
	kread,
	kgetch,
	kwait
};

static int FAR
mcal (POINTER *p)
{
        p = p;
	return (0);
}

static int FAR
minit (POINTER *p)
{
        p = p;
	return (0);
}

static void FAR
mterm (POINTER *p)
{
	p->flags = 0;
}

static int win_x, win_y, button1 = 0, button2 = 0;
#define PO	p->opt

static int FAR
mouse_read (POINTER *p)
{
	if (win_x > CS->sizex)
	    	win_x = CS->sizex;
	else if (win_x < 0)
	    	win_x = 0;
	if (win_y > CS->sizey)
	    	win_y = CS->sizey;
	else if (win_y < 0)
		win_y = 0;

  	p->a[PO[3]] = muldiv (win_y, 200, CS->sizey) - 100;	/* y */
  	p->a[PO[3]] *=  PO[2];
  	p->a[PO[1]] = muldiv (win_x, 200, CS->sizex) - 100;	/* x */
  	p->a[PO[1]] *=  -PO[0];
  	p->b[PO[4]] += button1;
  	p->b[PO[5]] += button2;
  	button1 = button2 = 0;

  	return (0);
}

struct PtrDriver PtrMouse = {
	"MOUSE",
	0,
	minit,
	mterm,
	mcal,
	mcal,			/* center */
	mouse_read,
	std_key
};

/* procedure called by WINDOWS when an event occurs in the fly8 display window
*/
long FAR PASCAL
Fly8WndProc (HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
    	PAINTSTRUCT ps;
    	POINT pt;

    	switch (message) {
       
       	case WM_DESTROY:             /* quit the Fly8 application */
          	PostQuitMessage ( 0 );
          	die ();
          	break;

       	case WM_PAINT:               /* paint the window */
          	BeginPaint ( hWnd, (LPPAINTSTRUCT)&ps );
          	GetClientRect (hWnd, &rect);
          	EndPaint ( hWnd, (LPPAINTSTRUCT)&ps );
          	break;

       	case WM_SETFOCUS:               /* just got the input focus */
		SelectPalette (hdc, hpal, FALSE);
          	RealizePalette (hdc);	/* remap colours as we lost the focus */
          	break;

       	case WM_SIZE:               /* resize the window */
          	GetClientRect (hWnd, &rect);
  		CS->sizex = rect.right;
  		CS->sizey = rect.bottom;
  		set_screen (rect.right, rect.bottom);
          	break;

      	case WM_MOUSEMOVE:
      		button1 = MK_LBUTTON & wParam;
      		button2 = MK_RBUTTON & wParam;
      		pt.x = LOWORD(lParam);
      		pt.y = HIWORD(lParam);
      		ScreenToClient (hWnd, &pt); 
             	win_x = pt.x;
             	win_y = pt.y;	
         	break;

      	case WM_LBUTTONDOWN:
                button1 = 1;
         	break;

      	case WM_RBUTTONDOWN:
                button2 = 1;
         	break;
#if 0
      	case WM_LBUTTONUP:
/*         	wsprintf(ButtonText, "WM_LBUTTONUP: %x, %d, %d",
                	wParam, LOWORD(lParam), HIWORD(lParam));*/
         	break;

      	case WM_LBUTTONDBLCLK:
/*         	wsprintf(ButtonText, "WM_LBUTTONDBLCLK: %x, %d, %d",
                	wParam, LOWORD(lParam), HIWORD(lParam));*/
	        break;

      	case WM_KEYDOWN:
/*          	wsprintf(KeyboardText, "WM_KEYDOWN: %x, %x, %x",
              		wParam, LOWORD(lParam), HIWORD(lParam));*/
          	break;

      	case WM_KEYUP:
/*          	wsprintf(KeyboardText, "WM_KEYUP: %x, %x, %x",
              		wParam, LOWORD(lParam), HIWORD(lParam));*/
          	break;
#endif
	case WM_CHAR:		/* all normal alphanumeric keys */
              	key = wParam;
              	pressed = 1;
              	break;
              	
      	case WM_KEYDOWN:	/* catch special keys eg F1 - F12 */
               	switch (wParam) {
                        case VK_F1:
                        	key = K_F1;
		              	pressed = 1;
                        	break;
                        case VK_F2:
                        	key = K_F2;
		              	pressed = 1;
                        	break;
                        case VK_F3:
                        	key = K_F3;
		              	pressed = 1;
                        	break;
                        case VK_F4:
                        	key = K_F4;
		              	pressed = 1;
                        	break;
                        case VK_F5:
                        	key = K_F5;
		              	pressed = 1;
                        	break;
                        case VK_F6:
                        	key = K_F6;
		              	pressed = 1;
                        	break;
                        case VK_F7:
                        	key = K_F7;
		              	pressed = 1;
                        	break;
                        case VK_F8:
                        	key = K_F8;
		              	pressed = 1;
                        	break;
                        case VK_F9:
                        	key = K_F9;
		              	pressed = 1;
                        	break;
                        case VK_F10:
                        	key = K_F10;
		              	pressed = 1;
                        	break;
                        case VK_F11:
                        	key = K_F11;
		              	pressed = 1;
                        	break;
                        case VK_F12:
                        	key = K_F12;
		              	pressed = 1;
                        	break;
                        case VK_UP:
                        	key = K_UP;
		              	pressed = 1;
                        	break;
                        case VK_DOWN:
                        	key = K_DOWN;
		              	pressed = 1;
                        	break;
                        case VK_LEFT:
                        	key = K_LEFT;
		              	pressed = 1;
                        	break;
                        case VK_RIGHT:
                        	key = K_RIGHT;
		              	pressed = 1;
                        	break;
                        case VK_END:
                        	key = K_END;
		              	pressed = 1;
                        	break;
                        case VK_HOME:
                        	key = K_HOME;
		              	pressed = 1;
                        	break;
                        case VK_INSERT:
                        	key = K_INS;
		              	pressed = 1;
                        	break;
                        case VK_NUMPAD5:
                        	key = K_CENTER;
		              	pressed = 1;
                        	break;
			default:	/* if not a special key do not keep it */
                		break;
                }
          	break;

       	default:
          	return DefWindowProc( hWnd, message, wParam, lParam );
          	break;
       	}

    	return(0L);
}
