/* --------------------------------- timer.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Time services for UNIX. The rsolution depends on your ftime().
*/

#include <stdio.h>
#include <time.h>
#include <sys/timeb.h>

#include "fly.h"

static Ulong FAR
timer_milli (void)
{
	struct timeb	tm;

	ftime (&tm);
	return (tm.time*1000L + tm.millitm);
}

static int FAR
timer_hires (void)		/* get fastest timer available */
{
	static int last = 0;

	return (++last);	/* how fast do you want it? */
}

static int FAR
timer_init (void)
{
	return (0);
}

static void FAR
timer_term (void)
{
	return;
}

static char * FAR
timer_ctime (void)
{
	time_t	tm;
	char	*t;

	tm = time (0);
	t = ctime (&tm);
	t[strlen (t) - 2] = '\0';	/* kill NewLine */
	return (t);
}

struct TmDriver TmDriver = {
	"ftime()",
	0,
	timer_init,
	timer_term,
	timer_milli,
	timer_hires,
	timer_ctime
};
