/*
	i2cfindsis96x: Find and return the SiS96x i2c bus device for
				   the digimatrix setpanel program, for both 2.4 
				   and 2.6 kernels.
	Based heavily on the codebase for the header given directly below.
	Andrew Calkin 2005

	Original header:
    i2cbusses: Print the installed i2c busses for both 2.4 and 2.6 kernels.
               Part of user-space programs to access for I2C 
               devices.
    Copyright (c) 1999-2003  Frodo Looijaard <frodol@dds.nl> and
                             Mark D. Studebaker <mdsxyz123@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>
#include <stdio.h>
#include <limits.h>
#include <dirent.h>
#include <stdlib.h>
#define NAME_STR "SiS96x SMBus adapter"
#define NAME_LEN 20
/*#define NAME_STR "bt848"
#define NAME_LEN 5 */
int find_i2c_sis96x(void)
{
	FILE *fptr;
	char s[100];
	struct dirent *de, *dde;
	DIR *dir, *ddir;
	char dev[NAME_MAX], fstype[NAME_MAX], sysfs[NAME_MAX], n[NAME_MAX];
	int foundsysfs = 0;
	char *i2cdev;
	char *name_str;

	void print_error_msg(void);
	int sysfs_i2c_check(FILE *f);

	/* look in /proc/bus/i2c first (2.4 kernels) */
	if((fptr = fopen("/proc/bus/i2c", "r"))) {
		while(fgets(s, 100, fptr)) {
			i2cdev=s; 
			name_str=strchr(s,'\t'); // Find 1st tab.
			*name_str='\0'; // Terminate string for i2cdev.
			name_str=strchr((name_str+1),'\t'); // Find 2nd tab.
			if (!strncmp((name_str+1),NAME_STR, NAME_LEN)){
				printf("Found SiS96x SMBus adapter at i2c bus #%s\n",
					(i2cdev+4));
				fclose(fptr);
				return(atoi((i2cdev+4)));
			}
		}
	}
		
	/* Now look in sysfs, since not in /proc */
	/* First figure out where sysfs was mounted */
	if ((fptr = fopen("/proc/mounts", "r")) == NULL) {
		/* proc not mounted, quit with error msg. */
		print_error_msg();
		return(-1);
	}

	while (fgets(n, NAME_MAX, fptr)) {
		sscanf(n, "%[^ ] %[^ ] %[^ ] %*s\n", dev, sysfs, fstype);
		if (strcasecmp(fstype, "sysfs") == 0){ 
			foundsysfs++;
			break;
		}
	}
	fclose(fptr);

	if (foundsysfs == 0) {
		/* sysfs not mounted, quit with error msg. */
		print_error_msg();
		return(-1);
	}

	/* Bus numbers in i2c-adapter don't necessarily match those in
	i2c-dev and what we really care about are the i2c-dev numbers.
	Unfortunately the names are harder to get in i2c-dev */
	strcat(sysfs, "/class/i2c-dev");
	if((dir = opendir(sysfs)) == NULL){
		print_error_msg();
		return(-1);
	}

	/* go through the busses */
	while ((de = readdir(dir)) != NULL) {
		if (!strcmp(de->d_name, "."))
			continue;
		if (!strcmp(de->d_name, ".."))
			continue;

		/* this should work for kernels 2.6.5 or higher and */
		/* is preferred because is unambiguous */
		sprintf(n, "%s/%s/name", sysfs, de->d_name);
		if((fptr = fopen(n, "r")) != NULL)
			if (!sysfs_i2c_check(fptr)){
				fclose(fptr);
				printf("Found SiS96x SMBus adapter at i2c bus #%s\n",
					(de->d_name+4));
				return(atoi((de->d_name+4)));
			}

		/* this seems to work for ISA */
		sprintf(n, "%s/%s/device/name", sysfs, de->d_name);
		if((fptr = fopen(n, "r")) != NULL)
			if (!sysfs_i2c_check(fptr)){
				fclose(fptr);
				printf("Found SiS96x SMBus adapter at i2c bus #%s\n",
					(de->d_name+4));
				return(atoi((de->d_name+4)));
			}
		
		/* non-ISA is much harder */
		/* and this won't find the correct bus name if a driver
		has more than one bus */
		sprintf(n, "%s/%s/device", sysfs, de->d_name);
		if(!(ddir = opendir(n)))
			continue;       	
		while ((dde = readdir(ddir)) != NULL) {
			if (!strcmp(dde->d_name, "."))
				continue;
			if (!strcmp(dde->d_name, ".."))
				continue;
			if ((!strncmp(dde->d_name, "i2c-", 4))) {
				sprintf(n, "%s/%s/device/%s/name",
			        sysfs, de->d_name, dde->d_name);
				if((fptr = fopen(n, "r")) != NULL)
					if (!sysfs_i2c_check(fptr)){
						fclose(fptr);
						printf("Found SiS96x SMBus adapter at i2c bus #%s\n",
							(de->d_name+4));
						return(atoi((dde->d_name+4)));
					}
			}
		}
		closedir(ddir);
	}
	closedir(dir);

	/* If it has reached this point, then all attempts have failed.
	Print error msg and exit. */
	print_error_msg();
	return(-1);
}

void print_error_msg(void)
{
	fprintf(stderr,"Error: No I2C busses found!\n"
		"Be sure you have modprobed the i2c-dev and\n"
		"SiS96x modules. The proc (and sysfs, if using\n"
		"a 2.6.x kernel) filesystems must also be mounted.\n");
}

int sysfs_i2c_check(FILE *f)
{
	char	x[120];
	fgets(x, 120, f);
	if(!strncmp(x, NAME_STR, NAME_LEN))
		return(0);
	else
		return(1);
}
