//***************************************************************************
//
// Copyright (c) 1991-93 Sierra Semiconductor Corp.
//
// FILE:    aria.h
//
// LANGUAGES:
//          Microsoft C Versions 5.0, 6.0, and 7.0
//          Borland Turbo C Versions 1.5 and 2.0
//
// DESCRIPTION:
//
//          Header file for Aria multimedia applications
//
// AdLib is a trademark of AdLib Inc.
// Aria, Aria Synthesizer and Aria Listener are trademarks of Sierra
//  Semiconductor Corp.
// QSound is a trademark of Archer Communications
// Sound Blaster is a trademark of Creative Labs Inc.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\aria.h_v   2.5   08 Dec 1993 13:50:36   golds  $
// $Log:   F:\projects\ariai\dos\archives\aria.h_v  $
// 
//    Rev 2.5   08 Dec 1993 13:50:36   golds
// Fixed bug in ADPCM play/record for older ROMs (version 1.6)
// 
//    Rev 2.2   03 Sep 1993 10:02:56   golds
// Fixed recording from external input source
// 
//    Rev 2.1   13 Aug 1993 09:23:10   golds
// Reverb support added, 16-channel MIDI, other optimizations
// 
//    Rev 2.0   24 Jun 1993 14:04:14   golds
// Initial revision.

#ifdef TURBOC                       // Defines for Turbo C 1.5 and 2.0
#define __MSC
#define GETVECT      getvect
#define SETVECT      setvect
#define ASM          asm
#define FAR          far
#define NEAR         near
#define HUGE         huge
#else                               // Defines for Microsoft C 5.0 -> 7.0
#define GETVECT      _dos_getvect
#define SETVECT      _dos_setvect
#define ASM          _asm
#define FAR          _far
#define NEAR         _near
#define HUGE         _huge
#endif

#ifndef PRIVATE_IO
#ifdef TURBOC                       // Defines for Turbo C 1.5 and 2.0
#define OUTPW        outport
#define INPW         inport
#define OUTP         outportb
#define INP          inportb
#else                               // Defines for Microsoft C 5.0,6.0,7.0
#define OUTPW        outpw
#define INPW         inpw
#define OUTP         outp
#define INP          inp
#endif
#endif

#define FILELENGTH   filelength

// Data type definitions

#define VOID   void

typedef int	   BOOL;
#define FALSE 	0
#define TRUE   1

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

typedef unsigned int	   UINT;
typedef signed long     LONG;

typedef char NEAR*   PSTR;
typedef char NEAR*   NPSTR;
typedef char FAR*    LPSTR;
typedef BYTE NEAR*   PBYTE;
typedef BYTE FAR*	   LPBYTE;

typedef BYTE HUGE*   HPBYTE;

typedef int NEAR*	   PINT;
typedef int FAR*     LPINT;

typedef WORD NEAR*   PWORD;
typedef WORD FAR*    LPWORD;

typedef long NEAR*   PLONG;
typedef long FAR*	   LPLONG;

typedef DWORD NEAR*  PDWORD;
typedef DWORD FAR*   LPDWORD;

typedef VOID FAR*    LPVOID;

#define DEF_VERSION  0x0100  // Default Aria system ROM version number
#define DEF_SYSVER   0x0001  // Default Aria system version number
#define DEF_DSPVER   0x0100  // Default Aria DSP version number

#define DSPBASE1     0x280   // Alternate DSP base ports
#define DSPBASE2     0x290
#define DSPBASE3     0x2A0
#define DSPBASE4     0x2B0

#define DEF_DSPBASE DSPBASE2 // Default DSP base port

#define ARIAINT1     10      // Alternate PC interrupts
#define ARIAINT2     11
#define ARIAINT3     12

#define DEF_ARIAINT ARIAINT1 // Default Aria PC interrupt

#define DMACHAN5     5       // Alternate Aria DMA channels
#define DMACHAN6     6

#define DEF_DMACHAN DMACHAN5 // Default Aria DMA channel

// PC write ports (data and control registers)

#define DSPDATA      (dspbase)   // DSP data port
#define DSPCONTROL   (dspbase+2) // DSP control port
#define DMAADDRESS   (dspbase+4) // DMA address port
#define DMADATA      (dspbase+6) // DMA data port

// PC read ports (status register)

#define DSPSTATUS    (dspbase+2) // DSP status port

// Note that DMADATA may also be read for direct access to DSP memory

// Constants for setting the DSP board control port:

#define INTPC_DSPRD     0x0001   // Interrupt PC on DSP read
#define INTPC_DSPWR     0x0002   // Interrupt PC on DSP write
#define INTDSP_PCRD     0x0004   // Interrupt DSP on PC read
#define INTDSP_PCWR     0x0008   // Interrupt DSP on PC write
#define INTPC_DMADONE   0x0010   // Interrupt PC on DMA completion
#define SAMP_RATE       0x0060   // Sample rate mask
#define  SAMP_44K       0x0000   //    44.10 kHz
#define  SAMP_32K       0x0020   //    31.50 kHz
#define  SAMP_22K       0x0040   //    22.05 kHz
#define  SAMP_16K       0x0060   //    15.75 kHz
#define C2MODE          0x0080   // Aria Wave Synthesis select
#define DSP_RESET       0x0100   // Reset DSP
#define DMA_DSPTOPC     0x0200   // DMA direction - DSP to PC
#define DMA_XFR         0x0400   // Initiate DMA transfer
#define ADC_SRC_AUX     0x0800   // ADC record source select
#define ADC_STEREO      0x1000   // ADC mono/stereo select
#define ADC_SRC_RIGHT   0x2000   // ADC monophonic source
#define ADC_DISABLE     0x4000   // ADC enable/disable
#define PORT0_BUSY      0x8000   // Data port busy flag

//*** Joystick Port ***

#define JOYPORT      0x201       // Joystick base port

//*** MIDI Port ***

#define MIDIBASE1    0x320       // Alternate MIDI base ports
#define MIDIBASE2    0x330

#define DEF_MIDIBASE MIDIBASE2   // Default MIDI base port

#define MIDIINT1     5           // Alternate MIDI interrupts
#define MIDIINT2     7
#define MIDIINT3     9           // Note: IRQ 9 requires that two
                                 //   interrupt controllers be
                                 //   programmed.

#define DEF_MIDIINT  MIDIINT3    // Default MIDI interrupt

#define MIDIDATA     (midibase)     // MIDI data port
#define MIDISTAT     (midibase+1)   // MIDI status port
#define MIDICMD      (midibase+1)   // MIDI command port

// Useful MIDI Constants and Commands

#define DRR          0x40     // MIDI status port write mask
#define DSR          0x80     // MIDI status port read mask

#define MWITHTIMING  0x34     // Send zero timing byte in Data In Stop mode
#define MUART        0x3F     // Switch to UART mode
#define MTHRUOFF     0x88     // MIDI thru off
#define MTHRUON      0x89     // MIDI thru on
#define MDSTOPOFF    0x8A     // Data In Stop mode off
#define MDSTOPON     0x8B     // Data In Stop mode on
#define MGETRECCNT   0xAB     // Read and clear record counter
#define MGETVERSION  0xAC     // Get version number
#define MGETREVIS    0xAD     // Get revision number
#define MGETTEMPO    0xAF     // Read tempo setting
#define MTB48        0xC2     // Set timebase to 48 ticks per beat
#define MTB72        0xC3     // Set timebase to 72 ticks per beat
#define MTB96        0xC4     // Set timebase to 96 ticks per beat
#define MTB120       0xC5     // Set timebase to 120 ticks per beat
#define MTB144       0xC6     // Set timebase to 144 ticks per beat
#define MTB168       0xC7     // Set timebase to 168 ticks per beat
#define MTB192       0xC8     // Set timebase to 192 ticks per beat
#define MSETTEMPO    0xE0     // Set tempo in beats per minute
#define MACK         0xFE     // MIDI acknowledge
#define MRESET       0xFF     // Reset MIDI interface


//*** Adlib / Sound Blaster Ports ***

#define ADLIBREGISTER   0x388          // AdLib address register
#define ADLIBDATA       0x389          // AdLib data register

#define SB_BASE1        0x220          // Alternate Sound Blaster base ports
#define SB_BASE2        0x230

#define DEF_SB_BASE     SB_BASE1       // Default Sound Blaster base port

#define SB_INT1         5              // Alternate Sound Blaster interrupts
#define SB_INT2         7
#define SB_INT3         9

#define DEF_SB_INT      SB_INT2        // Default Sound Blaster interrupt

#define SB_FM_REGISTER  (sb_base+8)    // Sound Blaster synth register
#define SB_FM_DATA      (sb_base+9)    // Sound Blaster data register

#define SB_RESET        (sb_base+6)    // Sound Blaster reset port
#define SB_READDATA     (sb_base+10)   // Sound Blaster read data port
#define SB_WRITEDATA    (sb_base+12)   // Sound Blaster write data port
#define SB_WRB_STATUS   (sb_base+12)   // Sound Blaster data/command port
#define SB_RDD_STATUS   (sb_base+14)   // Sound Blaster status port


//*** DSP Memory Locations and Flags ***

#define HW_OFFSET1     0x6050 // Hardware features flag 1

#define  ROM_SIZEMASK  0x000F //  ROM size mask
#define   ROM_64K      0x0000 //   64K ROM bit flag
#define   ROM_128K     0x0001 //   128K ROM bit flag
#define   ROM_256K     0x0002 //   256K ROM bit flag
#define   ROM_512K     0x0003 //   512K ROM bit flag
#define   ROM_1024K    0x0004 //   1M ROM bit flag
#define   ROM_2048K    0x0005 //   2M ROM bit flag
#define   ROM_4096K    0x0006 //   4M ROM bit flag
#define   ROM_8192K    0x0007 //   8M ROM bit flag
#define   ROM_16384K   0x0008 //   16M ROM bit flag
#define  ROM_RESMASK   0x0010 //  ROM bit resolution mask
#define   ROM_8BIT     0x0000 //   8-bit ROM resolution flag
#define   ROM_16BIT    0x0001 //   16-bit ROM resolution flag
#define  MIXER_MASK    0x00E0 //  Mixer type mask
#define   NO_MIXER     0x0000 //   No mixer bit flag
#define   DISCRETEMIX1 0x0001 //   Discrete mixer type 1 bit flag
#define   DISCRETEMIX2 0x0002 //   Discrete mixer type 2 bit flag
#define   DISCRETEMIX3 0x0003 //   Discrete mixer type 3 bit flag
#define   MIXERCHIP1   0x0004 //   Single chip integrated mixer
#define  RAM_SIZEMASK  0x0700 //  RAM size mask
#define   RAM_8K       0x0000 //   8K RAM bit flag
#define   RAM_16K      0x0001 //   16K RAM bit flag
#define   RAM_32K      0x0002 //   32K RAM bit flag
#define   RAM_40K      0x0003 //   40K RAM bit flag
#define   RAM_64K      0x0004 //   64K RAM bit flag
#define  ADC_RESMASK   0x1800 //  ADC resolution mask
#define   ADC_8BIT     0x0000 //   8-bit ADC flag
#define   ADC_10BIT    0x0001 //   10-bit ADC flag
#define   ADC_12BIT    0x0002 //   12-bit ADC flag
#define   ADC_16BIT    0x0003 //   16-bit ADC flag
#define  PHONE_INTFC   0x2000 //  Telephone interface bit flag

#define HW_OFFSET2     0x6051 // Hardware features flag 2 (reserved)

#define SW_OFFSET1     0x6052 // Software features flag 1
#define  SB_MASK       0x0002 //  Sound Blaster emulation mask
#define  PCM_MASK      0x0004 //  Aria PCM audio mask
#define  SYNTH_MASK    0x0008 //  Aria Synthesizer mask
#define  PHONE_MASK    0x0010 //  Telephone interface bit mask
#define  SPEECH_MASK   0x0020 //  Aria Listener bit mask
#define  REVERB_MASK   0x0080 //  Reverb effects mask
#define  QSOUND_MASK   0x0100 //  QSound(TM) effects mask

#define SW_OFFSET2     0x6053 // Software features flag 2 (reserved)

#define DSP_VERSION    0x60C0 // DSP version number
#define DSP_PARTCODE   0x60C3 // Sierra DSP part code:
#define  SC18025       0      //  0 = SC18025
#define  SC18026       1      //  1 = SC18026
#define PLAY_OFFSET    0x6100 // Digital playback buffer offset
#define REC_OFFSET     0x6101 // Digital recording buffer offset
#define DSP_INIT       0x6102 // DSP initialization flag
#define ROMWAVEFLAG    0x6103 // DSP ROM wave flag address
#define ROM_PARTCODE   0x6104 // ROM part code:
#define  SC18051       0x0215 //  512 Kb
#define  SC18052       0x0216 //    1 Mb
#define  SC18050       0x021E //   64 Kb + Aria Listener
#define  SC18053       0x021F //  512 Kb + Aria Listener
#define  SC18054       0x0220 //    1 Mb + Aria Listener
#define  SC18055       0x0228 //   64 Kb + SC18075 mixer
#define  SC18056       0x0229 //  512 Kb + SC18075 mixer
#define  SC18057       0x022A //    1 Mb + SC18075 mixer
#define  SC18058       0x0233 //  512 Kb + SC18075 mixer and Aria Listener
#define  SC18059       0x0234 //    1 Mb + SC18075 mixer and Aria Listener
#define SYSVERADDR     ROM_PARTCODE // For compatibility w/SD8025
#define WAVEBUFADDR    0x610C // ROM wave buffer address
#define  BUFADDRFIX    0x7800 //  Buffer address fix for ROM ver 1.6

#define DSP_FIFO       0x8000 // DSP FIFO buffers (ending offset)
#define WAVEBUFFER     0x8000 // ROM wave buffer

//*** PC AT constants ***

#define INTCTRLR0    0x21     // Primary interrupt controller port
#define INTCTRLR1    0xA1     // Secondary interrupt controller port

//*** DSP Command IDs ***

// System commands (0Xh)

#define DSPSYSTEM       0x0000   // System Initialization
#define  ARIA_SYNTH     0
#define  DEFAULT_SYNTH  1
#define DSPWAVEPARM     0x0002   // Download Wave Parameter Table
#define DSPAUDIOFORMAT  0x0003   // Digital Audio Format
#define  SRMASK         0x00F0
#define  SR11KHZ        0x0000
#define  SR22KHZ        0x0010
#define  SR44KHZ        0x0020
#define  SR32KHZ        0x0030
#define  SR16KHZ        0x0040
#define  SR8KHZ         0x0050
#define  MONO           0x0000
#define  STEREO         0x0001
#define  EIGHTBIT       0x0000
#define  SIXTEENBIT     0x0002
#define  ADPCM          0x0004
#define DSPMASTERVOL    0x0004   // Master Volume
#define DSPPACKETSIZE   0x0005   // Digital Audio Packet Size
#define DSPPLAYMODE     0x0006   // Playback Mode
#define  NOSYNTH        0x0000
#define  MINOPERATORS   0x0001
#define  MAXOPERATORS   0x0002
#define DSPAUXVOL       0x0007   // Auxiliary Volume
#define DSPEXTVOL       0x0008   // External Volume
#define DSPMIXERLEVEL   0x0009   // Mixer Level Select
#define  LINELEVEL      0x0000
#define  AMPLEVEL       0x0001
#define  MONITOR        0x0010
#define DSPGENPCINT     0x000A   // Generate PC Interrupt
#define DSPREADROM      0x000C   // Read system ROM block 
#define DSPADCSWITCH    0x000D   // Control Aria ADC (ON or OFF)

// PCM audio commands (1Xh)

#define DSPTRANSFER     0x0010   // Digital Audio Transfer
#define DSPPLAYSTART    0x0011   // Start Audio Playback
#define  INACTIVE       0
#define  PLAYING        1
#define DSPPLAYSTOP     0x0012   // Stop Audio Playback
#define DSPCHANNELVOL   0x0013   // Playback Channel Volume
#define DSPCHANNELPAN   0x0014   // Playback Channel Pan
#define DSPRECSTART     0x0015   // Start Audio Recording
#define  RECORDING      2
#define  EXTREC         0x0001
#define  AUXREC         0x0002
#define  OUTREC         0x0004
#define DSPRECSTOP      0x0016   // Stop Audio Recording
#define DSPPLAYVOL      0x0017   // Digital Audio Playback Volume

// Aria Synthesizer commands (2Xh)

#define DSPOPERON1      0x0020   // Operator On (Multiple loop)
#define DSPOPEROFF      0x0021   // Operator Off
#define DSPOPERCANCEL   0x0022   // Operator Cancel
#define DSPOPERON2      0x0023   // Operator On (Single loop)
#define DSPLFO_ON       0x0024   // LFO Activate
#define DSPLFO_OFF      0x0025   // LFO Deactivate
#define DSPAMP          0x0026   // Amplitude Change
#define DSPPAN          0x0027   // Pan Change
#define DSPPITCH        0x0028   // Pitch Change
#define DSPSYNTHVOL     0x0029   // Synthesis Volume
#define DSPLFORATE      0x002A   // LFO Rate Change
#define DSPLFODEPTH     0x002B   // LFO Depth Change
#define DSPTABLEMOD     0x002C   // Table Modify

// Extended mixer commands for boards with integrated mixer chip (3Xh)

#define DSPADCSOURCE    0x0030   // Select ADC source
#define DSPADCCONTROL   0x0031   // ADC enable/disable
#define DSPMONITORMODE  0x0032   // Mixer monitor mode
#define DSPMIXERMODE    0x0033   // Master monitor mode
#define DSPMIXERVOL     0x0034   // Mixer volume controls
#define DSPTONECTRL     0x0035   // Bass/treble tone control
#define DSPMIXERCTRL    0x003F   // Mixer chip register r/w

#define ADCOFF          0x00     // ADC source parameters
#define MICROPHONE      0x01
#define AUX2AUDIO       0x02
#define CDROMAUDIO      AUX2AUDIO
#define DSPOUTPUT       0x04
#define MASTERVOL       0x04
#define EXTERNAL        0x08
#define AUX1AUDIO       0x10
#define PHONEAUDIO      0x20

#define MONSTEREO       0        // Monitor parameters
#define MONLEFT         1
#define MONRIGHT        2
#define MONOFF          3

#define BASS            0        // Tone control parameters
#define TREBLE          1

// Reverb commands (7Xh)

#define DSPREVERBLEVEL  0x0072   // Reverb overall level
#define DSPREVERBMODE   0x0075   // Reverb preset mode
#define DSPREVERBWAVE   0x0076   // Select reverb level (wave audio)
#define DSPREVERBCHAN   0x0077   // Select reverb level (individual channels)

// QSound(TM) Virtual Audio commands (8Xh)

#define DSPQSOUNDMODE   0x0080   // Select QSound(TM) mode

#define QWAVE           0x0001   // QSound wave audio flag
#define QSYNTH          0x0002   // QSound synth audio flag

#define DSPTERMINATOR   0xFFFF   // Command string terminator


//*** ISR Application IDs ***

#define PCM_ID    0         // PCM digital audio
#define SB_ID     1         // Sound Blaster
#define SYNTH_ID  2         // Aria Synthesizer
#define PHONE_ID  4         // Telephone interface
#define SPEECH_ID 5         // Aria Listener
#define SPARE_ID  6         // Spare application ID
#define REVERB_ID 7         // Reverb effects
#define QSOUND_ID 8         // QSound(TM) effects


//*** Maximum Values ***

#define DSPMAXOPS 32        // Maximum number of synthesis operators
#define DSPMINOPS 20        // Minimum number of synthesis operators
#define MAXPERCUSSIONON 8   // Maximum number of percussion operators
#define MINPERCUSSIONON 5   // Minimum number of percussion operators
#define MAXLFOS   16        // Maximum number of Low Frequency Oscillators
#define MAXWPTS   80        // Maximum number of Wave Parameter Tables
#define MAXVOL    0x7FFF    // Maximum volumes
#define MAXPAN    0x7F      // Maximum pan value
#define MAXLFODEPTH    0xFF // Maximum LFO depth
#define MODE0_CHANNELS    4 // Number of audio playback channels in
                            //  playback mode 0
#define MODE1_CHANNELS    1 // Number of audio playback channels in
                            //  playback mode 1
#define MODE2_CHANNELS    2 // Number of audio playback channels in
                            //  playback mode 2
#define MAXRECCHANNELS    2 // Maximum number of audio recording channels
#define MAXSTEREOCHANNELS 2 // Maximum number of stereo channels

#define DEF_PACKETSIZE  512 // Default transfer packet size
#define SYSTEM_WAIT    3000 // Maximum wait loop for IRQ and DMA detect


// Macro to return digital audio FIFO buffer location:
//    ch   = audio channel number (0 to 3)
//    offs = offset value read at DSP location 0x6100 (playback) or
//                                             0x6101 (recording).

#define getFIFOaddr(ch,offs) (DSP_FIFO-(((((ch)+1)*(packetSize<<1)))+(offs)))


// POPF may not necessarily restore interrupt enable/disable flag
// in enhanced mode. We have to issue "STI" explicitly, providing
// we want to enable interrupts.

#ifdef TURBOC
#define DISABLE  disableintr();
#define ENABLE   enableintr();
#else
#define DISABLE {ASM  pushf      \
                 ASM  pushf      \
                 ASM  pop   ax   \
                 ASM  test  ah,2 \
                 ASM  jz    $+3  \
                 ASM  cli}

#define ENABLE  {ASM  pop   ax   \
                 ASM  test  ah,2 \
                 ASM  jz    $+3  \
                 ASM  sti}
#endif

// Structure to contain system capabilities
//   SystemInit() must be called once prior to using this structure!!

typedef struct ariacaps_tag
   {
   WORD  version;         // Aria ROM version code
   WORD  ROMsize;         // ROM size (in Kbytes): 64, 128, 512, 1024,
                          //                       2048, 4096, 8192 or 16384
   WORD  ROMwidth;        // ROM wave table bit resolution:  8 or 16
   WORD  mixerType;       // Mixer type: 0 = no mixer (for ext. or aux. in)
                          //             1 = discrete analog mixer
                          //             4 = single chip integrated mixer
   WORD  RAMsize;         // RAM size in Kwords: 8, 16, 32, 40 or 64
   WORD  ADCbits;         // ADC bit resolution: 8, 10, 12 or 16
   BOOL  phoneInterface;  // Phone interface present?  0=no, 1=yes
   WORD  DSPapps;         // DSP applications available:
                          //      BIT     APPLICATION
                          //      ---     -----------------------
                          //       0      Reserved
                          //       1      Sound Blaster emulation
                          //       2      Aria PCM digital audio
                          //       3      Aria Synthesizer
                          //       4      Telephone interface
                          //       5      Aria Listener
                          //       6      Reserved
                          //       7      Reverb effects
                          //       8      QSound(TM) effects
   } ARIACAPS;

#define APPSUPPORTED(n) (AriaCap.DSPapps & n)
#define MIXERCHIP       (AriaCap.mixerType >= MIXERCHIP1)

//*** PCM Wave Channel Structure ***

typedef struct ariawave_tag
   {
   HPBYTE audioPtr;
   HPBYTE audioStart;
   DWORD  audioSize;
   DWORD  bufferSize;
   DWORD  bufferOffset;
   WORD   audioPending;
   short  status;
   } ARIAWAVE;


//*** Patch File Defines and Structures ***

#define PATCHNAMELEN    13    // Character in patch name length
#define MAXOPSPERPATCH  8     // Maximum number of operators per patch
#define MAXSTAGES       8     // Maximum number of envelope stages
#define MAXWAVESPEROP   8     // Maximum number of waves per operator

// Wave Parameter Table LFO structure, for use with SetWaveParameter()

#define VIBLFO          0     // Vibrato LFO array index
#define TREMLFO         1     // Tremolo LFO array index
#define PANLFO          2     // Pan mod LFO array index

typedef struct wptLFOstruct
   {
   WORD LFOnum;
   WORD LFOdepth;
   } WPTLFO;

// Patch bank header structure (version 1)

typedef struct bankstruct
   {
   BYTE version;
   char name[PATCHNAMELEN];
   BYTE patchCount;
   } BANKDEF;

// Patch bank header structure (version 2)

typedef struct bankstruct2
   {
   BYTE version;
   BYTE patchCount;
   } BANKDEF2;

// Modulator definition

typedef struct modulator
   {
   WORD speed;
   BYTE shape;
   BYTE depth;
   } MODULATORDEF;

// Patch definition (version 1)

typedef struct patchstruct
   {
   char   name[PATCHNAMELEN];
   BYTE   level;
   WORD   operatorID[MAXOPSPERPATCH];
   BYTE   patchID;
   BYTE   minOperators;
   BYTE   totalOperators;
   BYTE   pitchWheel;
   MODULATORDEF vibmod;
   MODULATORDEF tremmod;
   MODULATORDEF panmod;
   BYTE   ctrlID[3];
   BYTE   ctrlDepth[3];
   BYTE   ctrlUse[3];
	BYTE   pan;
   } PATCHDEF;

// Patch definition (version 2)

typedef struct patchstruct2
   {
   BYTE   patchID;
   BYTE   level;
   BYTE   totalOperators;
   BYTE   minOperators;
   WORD   opIndex[MAXOPSPERPATCH];
   BYTE   pitchWheel;
   MODULATORDEF vibmod;
   MODULATORDEF tremmod;
   MODULATORDEF panmod;
   BYTE   ctrlID;
   BYTE   ctrlDepth;
   BYTE   ctrlUse;
	BYTE   pan;
   } PATCHDEF2;

// Envelope word structure

typedef struct envstruct
   {
   WORD index  : 6;    // bits 0 to 5   (LS 6 bits)
   WORD length : 10;   // bits 6 to 15  (MS 10 bits)
   } ENVDEF;

// Wave definition structure

typedef struct wavestruct
   {
   WORD waveIndex;
   WORD blockCount : 8;
   WORD basePitch  : 7;  // bits 0 to 6
   WORD waveType   : 1;  // bit 7  (0 = loop, 1 = single)
   BYTE lowPitch;
   BYTE highPitch;
   } WAVEDEF;

// Operator structure (version 1)

typedef struct opstruct
   {
   WORD   operatorID;
   short  detune;
   short  transpose;
   BYTE   velocityTableID;
   BYTE   balance;
   BYTE   keybias;
   BYTE   opAmp;
   ENVDEF opEnvelope[MAXSTAGES];
   WAVEDEF waveTable[MAXWAVESPEROP];
   BYTE   minPitch;
   BYTE   maxPitch;
   BYTE   minVelocity;
   BYTE   maxVelocity;
   BYTE   pitchScale;
   BYTE   spare1;
   WORD   spare2;
   WORD   spare3;
   } OPDEF;

// Operator structure (version 2)

typedef struct opstruct2
   {
   short  detune;
   short  transpose;
   BYTE   velocityTableID;
   BYTE   balance;
   BYTE   keybias;
   BYTE   opAmp;
   ENVDEF opEnvelope[MAXSTAGES];
   BYTE   minPitch;
   BYTE   maxPitch;
   BYTE   minVelocity;
   BYTE   maxVelocity;
   BYTE   pitchScale;
   BYTE   waveCount;
   WAVEDEF waveTable[MAXWAVESPEROP]; // may actually be less
                                     // than [MAXWAVESPEROP]
   } OPDEF2;


//*** External global variables ***

extern WORD dspbase;          // DSP base address
extern WORD midibase;         // MIDI base address
extern WORD dspint;           // DSP interrupt number
extern WORD midiint;          // MIDI interrupt number
extern WORD sb_base;          // Sound Blaster base address
extern WORD sb_int;           // Sound Blaster interrupt no.
extern WORD dmachan;          // Aria DMA channel
extern WORD version;          // Version number - app should
                              //  call GetVersion()
extern WORD sysver;           // Aria system version
extern VOID (FAR PCMproc)();  // Aria PCM audio entry point
extern WORD ROMversion;       // Aria system ROM version
extern WORD wDSPpart;         // Aria DSP part number code
extern WORD wROMpart;         // Aria ROM part number code

extern WORD qsoundMode;

//*** External library declarations ***

extern short  GetAriaEnv (LPINT, LPINT, LPINT, LPINT);
extern UINT   GetDSPVersion (VOID);
extern UINT   GetVersion (VOID);
extern VOID   GetAriaCaps (LPBYTE);
extern short  GetInterrupt (VOID);
extern short  GetDMAChannel (VOID);
extern VOID   InstallAriaInt (VOID);
extern VOID   RemoveAriaInt (VOID);

extern short  RegisterISR (UINT, LPBYTE);
extern short  RemoveISR (UINT);
extern LPBYTE GetISRAddress (UINT);
extern short  SystemInit (UINT);
extern short  SetWaveParameter (UINT, ENVDEF FAR *, WPTLFO FAR *, UINT);
extern short  SetAudioFormat (UINT);
extern short  SetMasterVolume (UINT, UINT);
extern short  SetPacketSize (UINT);
extern short  SetPlaybackMode (UINT);
extern short  SetOperatorCount (UINT);
extern short  SetAuxVolume (UINT, UINT);
extern short  SetExtVolume (UINT, UINT);
extern short  SetMixerConfig (UINT, UINT, UINT, UINT, UINT);

extern short  SetAudioTransfer (VOID);
extern short  StartPlayback (UINT, LPBYTE, DWORD, DWORD);
extern short  StopPlayback (UINT);
extern short  SetChannelVolume (UINT, UINT);
extern short  SetChannelPan (UINT, UINT);
extern short  StartRecording (UINT, LPBYTE, DWORD, DWORD);
extern short  StopRecording (UINT);
extern short  SetPlaybackVolume (UINT, UINT);
extern short  SetRecordingVolume (UINT, UINT, UINT);

extern short  OperatorOn (UINT, UINT, UINT, UINT, UINT, UINT, UINT);
extern short  OperatorOff (UINT);
extern short  OperatorCancel (UINT);
extern short  TableModify (UINT, UINT, UINT, UINT);
extern short  LFOactivate (UINT, UINT, UINT);
extern short  LFOdeactivate (UINT);
extern short  SetLFOrate (UINT, UINT);
extern short  SetLFOdepth (UINT, UINT, UINT);
extern short  SetOperatorVolume (UINT, UINT);
extern short  SetOperatorPan (UINT, UINT);
extern short  SetOperatorPitch (UINT, UINT);
extern short  SetSynthVolume (UINT, UINT);

extern short  SelectADC (UINT);
extern short  SetMonitorMode (UINT, UINT);
extern short  SetMasterMode (UINT);
extern short  SetMixerVolume (UINT, UINT, UINT);
extern short  SetToneControl (UINT, UINT);

extern short  GenerateInt (VOID);
extern short  sendDSP (UINT);
extern VOID   putMem16 (UINT, UINT);
extern UINT   getMem16 (UINT);
extern DWORD  GetAudioPosition (UINT);
extern DWORD  GetBufferPosition (UINT);

extern short  SelectDSPApp (UINT, BOOL, LPBYTE);
extern UINT   GetDSPUsage (VOID);
extern short  SetListenerMode (UINT);
extern short  SetReverbMode (UINT);
extern short  SetReverbWave (UINT);
extern short  SetReverbChannel (UINT, UINT);
extern short  SetReverbLevel (UINT, UINT);
extern short  SetQSoundMode (UINT);

