/* ------------------------------------------------------------------------ */
/*                                                                          */
/*   TITLE       : DEMOCODR.C (MSC Version)                                 */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demonstrates the use of the various codec functions   */
/*       in the SGCODEC.LIB library.                                        */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <io.h>
#include  <dos.h>
#include  <bios.h>
#include  <stdio.h>
#include  <conio.h>
#include  <fcntl.h>
#include  <string.h>
#include  <stdlib.h>

//#include  "galaxy.h"
#include  "sgsdk.h"
#include  "sgc.h"

BYTE gbCardMode;
extern WORD gwCODECPort;
void codectest(void)
{

    printf("Previous Digital Mix value = %d\n", sgCodecAux_Mix(ON, 0));

    sgCodecAux_DMABlock(32768);

    printf("Revision ID = %d\n", sgCodecAux_get_RevisionID());
    
    printf("IRQ Pin Flag = %d\n", sgCodecAux_IRQEnable(ON));

    printf("Previous source = %d\n", sgCodecAux_set_input_source(CODEC_MIC));

    sgCodecAuxCS_set_alt_feature2(1,1);
}


main()
{
    unsigned version_number;
    int      iDSPPort=0x220, iMSSPort=0x530;
    FILE     *fOutput;

    /* Display SG SDK version number */
    version_number = sgGetCodecLibVersion();
    printf("Sound Galaxy Developer Kit, ");
    printf("SGCODEC Library Version ");
    printf("%d.%02d\n\n", (version_number>>8) & 0xff, version_number & 0xff);

    /***
       Insert BLASTER environment and CARD detection here if desired;
       otherwise, use the configuration program for Sound Galaxy cards
       to set to the desired settings

       Set global variables to the desired IO address, IRQ and DMA channel
       Remember to use the supplied configuration program to configure
       your sound card
    ***/
    printf("Please wait...acquiring card settings...\n");

    iDSPPort = TestBaseAddr();
    if (iDSPPort<0x220 || iDSPPort>0x240)
    {
        printf("Wrong base I/O address setting: %d\n", iDSPPort);
        printf("Please use configuration utility.\n");
        exit(1);
    }
    sgSetBaseAddress(iDSPPort);
    ResetDSP();
    if(TestSoundCardType()==0x11){
    SwitchModeToWSS();
    }

    iMSSPort = TestMSBABaseAddr();
    if (iMSSPort<0x530 || iMSSPort>0xf40)
    {
        printf("Wrong Wave Port I/O address setting: %d\n", iMSSPort);
        printf("Please use configuration utility.\n");
        exit(1);
    }
    sgSetCodecBaseAddress(iMSSPort);
    gwCODECPort = iMSSPort + 4;
    printf("DSP Port Address   = 0x%x\n", iDSPPort);
    printf("MSS Port Address   = 0x%x\n", iMSSPort);
    printf("Codec Port Address = 0x%x\n", gwCODECPort);

    if (!sgVerifyCodecHardware(gwCODECPort))
        printf("CODEC Port verified!\n");

    /* set to MSS mode */
    //if (!sgSetMode(MSSMODE))
    //    printf("Set to Microsoft's Windows Sound System mode.\n");

    /* test mixer functions */
    printf("\nPress any key to demonstrate some of the CODEC functions...\n");
    getch();
    codectest();

    printf("\nPress any key to record a WAVE file through CODEC...\n");
    getch();
    fOutput = fopen("DEMO.WAV", "wb");
    if (!fOutput)
    {
        printf("File create error!\n");
        return 1;
    }

    printf("\nRecording DEMO.WAV ... \n");
    printf("\nPress <ESC> key to quit!\n");
    sgCodecwd_input((WORD)iMSSPort, (WORD)iDSPPort, 1, fOutput,
                    11025, MONO, _8BIT);
//                    22050, STEREO, _16BIT);
    fclose(fOutput);

    /* set to Sound Blaster mode */
    //if (!sgSetMode(SB8MODE))
    //    printf("\nSet to Sound Blaster compatible mode.\n");
    if(TestSoundCardType()==0x11){
    SwitchModeToWSS();
    }

    return 0;
}

/* EOF: DEMOCODR.C */

