// Track.h : interface of the CTrack class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRACK_H__D0F5AF1B_15F8_44CC_9B15_90AD4EA54C2B__INCLUDED_)
#define AFX_TRACK_H__D0F5AF1B_15F8_44CC_9B15_90AD4EA54C2B__INCLUDED_

#include "TrackObjects.h"	// Added by ClassView
#include "TrackFileHeader.h"
#include "TrackHeader.h"	// Added by ClassView
#include "CCSetup.h"	// Added by ClassView

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBestLineSeg;
class CCommand;
class CTrackSeg;

/*signum function*/
short int sgn(double x);

/*round*/
int f2i(double f);

class CTrack : public CDocument
{
protected: // create from serialization only
	CTrack();
	DECLARE_DYNCREATE(CTrack)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTrack)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	void InsertCCLineSegment( CBestLineSeg * pBlNew, CBestLineSeg * pInsertAfter );
	void SetOldCCLineStyle( bool fOld );
	bool GetOldCCLineStyle();
	void InsertPitSegment( CTrackSeg * pTs );
	void InsertTrackSegment( CTrackSeg * pTs );
	void DeletePitSegment( CTrackSeg * pTs );
	void DeleteTrackSegment( CTrackSeg * pTs );
	void SetCurrentBestLineSeg( CBestLineSeg * pBestLineSeg );
	void SetCurrentTrackSeg( CTrackSeg * pTs );
	void SetCurrentPitSeg( CTrackSeg * pTs );
	CTrackHeader m_TrackHeader;
	CBestLineSeg * GetCurrentBestLineSeg();
	CBestLineSeg * GetBestLineSegs();
	CTrackSeg * GetPitSegs();
	void InsertCommand();
	CTrackSeg * GetTrackSegs();
	enum EditMode { emTrack, emPit, emBestLine };
	EditMode GetEditMode();
	EditMode SetEditMode( EditMode eNewMode );
	void ChangeCmd( int nComponent, int nValue );
	void DeleteSegment();
	void AddSegment();
	void RefreshTrack();
	void RefreshCCLine();
	CTrackSeg * GetCurrentPitSeg();
	void MoveEditPointer( char nChar );
	CTrackSeg * GetCurrentTrackSeg();
	unsigned int GetCCLineLength();
	virtual ~CTrack();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	bool m_fCCLineOld;
	CTrackSeg * DeleteSegment( CTrackSeg * &pTsList, CTrackSeg * pTs );
	short m_nLapNumIndex;
	CCCSetup m_CCsetup;
	void SaveCCSetup( FILE * pTrackFile );
	void LoadCCSetup( FILE * pTrackFile );
	byte m_baBackground[4096];
	byte m_baEndheader[256];
	void SaveTrackDataHeader( FILE * pTrackFile );
	void LoadTrackDataHeader( FILE * pTrackFile );
	void LoadPitlaneSegments( FILE * pTrackFile );
	CTrackObjects m_Objects;
	CTrackFileHeader m_TrackFileHeader;
	void CalculateChecksum( LPCTSTR lpszPathName );
	CCommand * AddCommand(CCommand *&pFirst, CCommand *&pLast);
	void FreeMemory();
	double m_dPitStartY;
	double m_dPitStartX;
	double m_dPitStartAngle;
	long m_lPithei;
	long m_lPitgrad;
	double m_dWidth;
	CTrackSeg * m_pTrackSegs;			// whole track
	CTrackSeg * m_pTrackSegCurrent;		// currently edited track segment
	CTrackSeg * m_pPitSegs;				// whole pit lane
	CTrackSeg * m_pPitSegCurrent;		// currently edited pit lane segment
	CBestLineSeg * m_pBestLineSegs;		// whole best line
	CBestLineSeg * m_pBestLineSegCurrent;	// currently edited best line segment
	EditMode m_eEditMode;
	CBestLineSeg * m_pLastBlSeg;
	void AddToCCLine( CBestLineSeg * pBlSeg );
	void LoadCCLine( FILE * pTrackFile );
	void LoadTrackSegments( FILE * pTrackFile );
	unsigned int m_uCCtlu;
	void LoadTrack( LPCTSTR lpszPathName );
	//{{AFX_MSG(CTrack)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

// global constants
extern double dANGLESCALE;
extern double dRADSCALE;
extern double dWIDTHSCALE;
extern double dCARWIDTH;
extern double dPITWIDTH;

// constants as hints for UpdateAllViews
#define UPD_HINT_PIT_SEG 1
#define UPD_HINT_TRACK_SEG 2
#define UPD_HINT_BEST_LINE_SEG 3
#define UPD_HINT_TRACK_SEG_INSERTED 4
#define UPD_HINT_PIT_SEG_INSERTED 5
#define UPD_HINT_TRACK_SEG_DELETED 6
#define UPD_HINT_PIT_SEG_DELETED 7

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACK_H__D0F5AF1B_15F8_44CC_9B15_90AD4EA54C2B__INCLUDED_)
