#if !defined(AFX_TRACKPROPERTIESVIEW_H__68345305_6A5F_4F21_889E_BF01EDD36016__INCLUDED_)
#define AFX_TRACKPROPERTIESVIEW_H__68345305_6A5F_4F21_889E_BF01EDD36016__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TrackPropertiesView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CTrackPropertiesView form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CTrackSeg;
class CTrack;
class CTrackHeader;
class CCommand;

class CTrackPropertiesView : public CFormView
{
protected:
	CTrackPropertiesView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CTrackPropertiesView)

// Attributes
public:
	CTrack* GetDocument();

// Form Data
public:
	//{{AFX_DATA(CTrackPropertiesView)
	enum { IDD = IDD_TRACK_PROPERTIES };
	CTreeCtrl	m_treeData;
	CListCtrl	m_listTrackHeaderProps;
	//}}AFX_DATA

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTrackPropertiesView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	void UpdateCCLine();
protected:
	void RelabelTrackSegments( HTREEITEM hParent );
	CTrackSeg * GetSelectedTrackSegment( HTREEITEM hParent );
	HTREEITEM GetTreeItem( HTREEITEM hItemRoot, CTrackSeg * pTs );
	HTREEITEM m_hPitlaneSegments;
	HTREEITEM m_hTrackSegments;
	HTREEITEM m_hTrackHeader;
	HTREEITEM m_hBestLineSegments;
	void EditTrackSegment( CTrackSeg * pTs );
	void EditCommand( CCommand * pCmd );
	void EditBestLineSegment( CBestLineSeg * pBl );
	void UpdateTreeCommands( HTREEITEM hItem, CCommand * pCmdList );
	virtual ~CTrackPropertiesView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void ConstructTrackProps();
	void ConstructPitlaneProps();
	void ConstructBestLineProps();
	void ConstructCommandProps();
	void ConstructCalcValueProps();
	void ConstructTrackDataProps();
	void ConstructCCSetupProps();

	void UpdateTrackProps(CTrackSeg *);
	void UpdatePitlaneProps(CTrackSeg *);
	void UpdateCommandProps( HTREEITEM hItem );
	void UpdateBestLineProps();
	void UpdateCalcValueProps();
	void UpdateTrackDataProps(const CTrackHeader &);
	void UpdateCCSetupProps();

	// Generated message map functions
	//{{AFX_MSG(CTrackPropertiesView)
	afx_msg void OnDblclkTrackHeaderProps(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnInsertCommand();
	afx_msg void OnEditCommand();
	afx_msg void OnEditPitSegment();
	afx_msg void OnEditTrackSegment();
	afx_msg void OnDeleteCommand();
	afx_msg void OnSelchangedDataTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEditBestLineSegment();
	afx_msg void OnInsertBestLineSegment();
	afx_msg void OnDeleteBestLineSegment();
	afx_msg void OnDeletePitSegment();
	afx_msg void OnDeleteTrackSegment();
	afx_msg void OnInsertPitSegment();
	afx_msg void OnInsertTrackSegment();
	afx_msg void OnPreferencesNewCcline();
	afx_msg void OnUpdatePreferencesNewCcline(CCmdUI* pCmdUI);
	afx_msg void OnPreferencesOldCcline();
	afx_msg void OnUpdatePreferencesOldCcline(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in TrackPropertiesView.cpp
inline CTrack* CTrackPropertiesView::GetDocument()
   { return (CTrack*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKPROPERTIESVIEW_H__68345305_6A5F_4F21_889E_BF01EDD36016__INCLUDED_)
