// TrackSeg.cpp: implementation of the CTrackSeg class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TrackEd.h"
#include "TrackSeg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC( CTrackSeg, CObject );

CTrackSeg::CTrackSeg()
{
	cmd = NULL;
	cumgrad = 0.0;
	cumheight = 0.0;
	cumlength = 0;
	curvature = 0;
	m_pPrev = NULL;	// pointer to previous segment in list
	m_pNext = NULL; // pointer to next segment in list
	fik = 0.0;		// angle at start of segment
	fiv = 0.0;		// angle at end of segment
	fim = 0.0;		// angle in the middle?
	flags = 0;
	height = 0;
	ks[ 0 ] = 0.0;	// track width left/right of middle at start of segment
	ks[ 1 ] = 0.0;
	vs[ 0 ] = 0.0;	// track width left/right of middle at end of segment
	vs[ 1 ] = 0.0; 
	kx = 0.0;		// start coordinates
	ky = 0.0;
	vx = 0.0;		// end coordinates
	vy = 0.0;
	lbank = 0;
	rbank = 0;
	length = 0.0;
	middle = 0;
	mx = 0.0;		// mid of segment coordinates
	my = 0.0;
	ox = 0.0;		// for curves: center of circle
	oy = 0.0;
	r = 0.0;		// radius
	sign = 0;		// indicator for right/left turn or straight (0)
	tlu = 0;		// length in track length units
	
	m_dR_Profile = 0.0;		// data for track profile display
	m_dS_Start = 0.0;
	m_dH_Start = 0.0;
	m_dS_Center = 0.0;
	m_dH_Center = 0.0;
	m_dS_End = 0.0;
	m_dH_End = 0.0;
}

CTrackSeg::~CTrackSeg()
{
	CCommand * pCmd = cmd;
	while ( cmd != NULL )
	{
		pCmd = cmd;
		cmd = cmd->m_pNext;
		delete pCmd;
	}
}

/// Add a new command to the command list

void CTrackSeg::InsertCommand()
{
	// First create the command
	CCommand * pNewCmd = new CCommand();
	// Set the command type to some value other than 0,
	// because otherwise it would be interpreted in the wrong
	// way when the track is immediately saved and later loaded
	// without changing the type.
	// Use type A5 because it seems to make not much of a difference...
	pNewCmd->cmd = 0xA5;
	// check if command list is empty
	if ( cmd == NULL )
	{
		cmd = pNewCmd;
	}
	else
	{
		// append to end of list
		CCommand * pCmd;
		pCmd = cmd;
		while ( pCmd->m_pNext != NULL )
			pCmd = pCmd->m_pNext;
		// pCmd points to last element of command list
		pCmd->m_pNext = pNewCmd;
		pCmd->m_pNext->m_pPrev = pCmd;
	}
}
