#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>
#include <stdarg.h>

typedef unsigned char  uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long  uint32_t;

#define IMUSE_ID 0x4553554DUL

#pragma pack(push, 1)
typedef struct {
  uint32_t muse;
  uint32_t unkn; /* unknown / unused */
  uint32_t offs; /* offset to FAT/TOC */
  uint32_t size; /* item count in FAT/TOC */
  char dupd[20];
  char dnew[20];
} mus_head;

typedef struct {
  char name[8];
  char extn[4];
  uint32_t offs;
  uint32_t size;
} mus_item;
#pragma pack(pop)

static uint8_t findcode[] = {
  0xFF ^      /* xor first byte with 0xFF to avoid this executable self-fix */
  0xA8, 0x80, /* test al, 080h */
  0x75, 0x04, /* jne +004h => +007h */
  0x31, 0xC0, /* xor  eax, eax */
  0x5B,       /* pop  ebx */
  0xC3        /* retn */
};

char *partcopy(char *d, char *s, uint16_t l) {
  while (l--) {
    *d = *s;
    if (!*s) { break; }
    d++;
    s++;
  }
  return(d);
}

char *namemake(mus_item *mi) {
char s[13], *h;
  h = s;
  h = partcopy(h, mi->name, 8);
  if (mi->extn[0]) {
    h = partcopy(h, ".", 1);
    h = partcopy(h, mi->extn, 3);
  }
  *h = 0;
  memcpy(mi->name, s, 13);
  return(mi->name);
}

/* this and next func needs to reduce DOS executable
   file size - avoid printf() tables and code linking */
void StrToHex(char *s, uint32_t n) {
uint16_t i;
  if (s) {
    i = 8;
    s += i;
    while (i--) {
      s--;
      *s = (n & 0x0F);
      *s += (*s <= 9) ? '0' : ('A' - 10);
      n >>= 4;
    }
  }
}

void StrMerge(char *buf, uint16_t len, ...) {
va_list args;
char *s;
  if (buf && len) {
    va_start(args, len);
    len--;
    do {
      s = va_arg(args, char *);
      if (s) {
        while (*s && len) {
          *buf = *s;
          buf++;
          s++;
          len--;
        }
      }
    } while (s && len);
    va_end(args);
    *buf = 0;
  }
}

void BuildLookupTable(uint8_t *q, uint16_t qs, uint8_t *t) {
uint16_t i;
  if (q && qs && t) {
    memset(t, qs, 256);
    qs--;
    for (i = 0; i < qs; i++) {
      t[q[i]] = qs - i;
    }
  }
}

uint16_t BoyerMooreHorspool(uint8_t *p, uint16_t ps, uint8_t *q, uint16_t qs, uint8_t *t) {
uint16_t i, s;
  if (p && ps && q && qs) {
    qs--;
    s = 0;
    while ((ps - s) > qs) {
      for (i = qs; (p[s + i] == q[i]); i--) {
        if (!i) {
          return(s + 1);
        }
      }
      s += t[p[s + qs]];
    }
  }
  return(0);
}

/* static buffer for real mode, max sign-safe 16bit value */
#define MAX_BUFF (0x7FFF)
static uint8_t buffer[MAX_BUFF];

uint32_t FindData(int fl, uint8_t *data, uint16_t much, uint32_t offs, uint32_t size) {
uint32_t full, find;
uint16_t l, w;
uint8_t table[256];
  /* by default - not found */
  find = 0;
  /* get file size */
  lseek(fl, 0, SEEK_END);
  full = tell(fl);
  /* check offset */
  offs = (offs < full) ? offs : full;
  if (!size) {
    /* whole file from current offset if size not specified */
    size = full - offs;
  } else {
    /* block size where to find */
    size = ((offs + size) <= full) ? size : (full - offs);
  }
  /* go to requred place */
  lseek(fl, offs, SEEK_SET);
  /* search */
  BuildLookupTable(data, much, table);
  /* at least one whole block available */
  while (size >= much) {
    l = (size < MAX_BUFF) ? size : MAX_BUFF;
    size -= l;
    read(fl, buffer, l);
    w = BoyerMooreHorspool(buffer, l, data, much, table);
    /* block found */
    if (w) {
      /* offset +1 if found */
      find = tell(fl) - l + (w - 1) + 1;
      break;
    } else {
      /* block not found and it's not partial (last) block */
      if (l == MAX_BUFF) {
        w = much - table[buffer[l - 1]];
        lseek(fl, tell(fl) - w, SEEK_SET);
        size += w;
      }
    }
  }
  return(find);
}

int main(int argc, char *argv[]) {
uint32_t i, sz;
mus_head mh;
mus_item mi;
char s[80];
int fl;
  puts(
    "Lucas Arts iMUSE General MIDI / Roland music drivers infinite loop fix v1.0\n"
    "(c) -=CHE@TER=- 2022\n"
    "e-mail: _CTPAX_@MAIL.RU\n"
    "http://ctpax-cheater.losthost.org/\n"
  );
  if ((argc < 2) || (argc > 3)) {
    puts(
      "Usage: imusefix <imuse.exe> [/u]\n"
      "/u - undo, removes this fix if specified and revert all changes back.\n"
      "\n"
      "Supported games:\n"
      "- Dark Forces (demo, full)\n"
      "- TIE Fighter (CD version)\n"
      "Maybe some other Lucas Arts games which uses iMUSE system.\n"
    );
    return(1);
  }
  fl = open(argv[1], O_RDWR | O_BINARY);
  if (fl == -1) {
    puts("Error: can't open input file for read-write.\n");
    return(2);
  }
  lseek(fl, 18, SEEK_SET);
  sz = 0;
  read(fl, &sz, 2);
  sz *= 16;
  lseek(fl, sz, SEEK_SET);
  memset(&mh, 0, sizeof(mh));
  read(fl, &mh, sizeof(mh));
  if (mh.muse != IMUSE_ID) {
    close(fl);
    puts("Error: not iMUSE.EXE or unsupported version.\n");
    return(3);
  }
  /* patch count */
  mh.muse = 0;
  /* save offset */
  mh.unkn = sz;
  /* restore first byte */
  findcode[0] ^= 0xFF;
  /* patch or revert back */
  findcode[3] ^= (argc == 2) ? 0x00 : 0x03; /* 4 <=> 7 */
  /* for each file */
  for (i = 0; i < mh.size; i++) {
    /* read iMUSE item */
    lseek(fl, mh.unkn + mh.offs + (i * sizeof(mi)), SEEK_SET);
    read(fl, &mi, sizeof(mi));
    /* find in current item data */
    sz = FindData(fl, findcode, sizeof(findcode), mh.unkn + mi.offs, mi.size);
    /* data found */
    if (sz) {
      sz--;
      lseek(fl, sz, SEEK_SET);
      /* new code */
      findcode[3] ^= 0x03; /* 4 <=> 7 */
      write(fl, findcode, sizeof(findcode));
      findcode[3] ^= 0x03; /* 4 <=> 7 */
      StrToHex(s, sz + 3);
      StrMerge(
        &s[8], sizeof(s) - 8,
        ": ", namemake(&mi),
        (argc == 2) ? " - fixed" : " - restored",
        NULL
      );
      puts(s);
      /* changes count */
      mh.muse++;
    }
  }
  close(fl);
  /* error code */
  if (!mh.muse) {
    puts("Error: required byte sequence not found in this file.\n");
    return(4);
  }
  puts("\ndone\n");
  return(0);
}
