'===================================*
'                                   *
' Music Quest Programmer's ToolKit  *
'                                   *
' Tape sync features                *
'                                   *
' Copyright (c) 1988                *
' By Music Quest, Inc.              *
'                                   *
'===================================*

DEFINT A-Z
' $include: 'mcc.cst'
' $include: 'mcc.inc'

'===================================*
'                                   *
' Chase Lock - SPP display          *
'                                   *
'===================================*
sub showspp

  cls
  print "MCC/MQX-32 Programmer's ToolKit - Song Position Pointer"
  print "Please start the tape or ESC to return"

  running%=0
  mccsetcoprocslih                      '* set up co-processor interrupt handler
  mccreset                              ' return to coproc mode *
  rc=mcccommand(DISABLE.ALL.THRU)       ' disable thru *
  rc=mcccommand(DISABLE.THRU)
  rc=mcccommand(ENABLE.SYSCOM.PC)       ' enable SPP msgs *
  rc=mcccommand(ENABLE.RT.PC)           ' enable real time msgs *
  rc=mcccommand(ACTIVE.TRACKS)          ' no tracks active *
  mccput(0)
  rc=mcccommand(ENABLE.MIDI.CTRL)       ' enable external MIDI control *
  rc=mcccommand(CLS.MODE)               ' enable CLS sync mode *
  rc=mcccommand(MIDI.SYNCH)

  while inkey$ = ""                     ' wait for key
    call sppefw(VARPTR(efw%),VARPTR(sppval%))  ' check efw status
    if efw% <> 0 then                   ' if SPP received
      if running% = 0 then
        print "Press ESC to return"
      end if
      running%=1
      print "SPP=" sppval "Measure(4/4)=" int(sppval/16)+1 " Beat(4/4)=" int((sppval MOD 16)/4)+1
    end if
    rtcmd%=realtimeefw
    if rtcmd% <>  0 then
      select case rtcmd%
        case &hFA                       ' start *
          print "MIDI Start"
        case &hFB                       ' continue *
          print "MIDI Continue"
        case &hFC                       ' stop *
          print "MIDI Stop"
      end select
    end if
  wend

  mccreset                              ' return to coproc mode *
end sub

'===================================*
'                                   *
' SMPTE frame trace                 *
'                                   *
'===================================*
sub showsmpte
  DIM smpteaddr as string*4

  cls
  print "MCC/MQX-32 Programmer's ToolKit - SMPTE Frame Trace"
  print "Please start the tape or ESC to return"

  running%=0
  mccsetcoprocslih                      '* set up co-processor interrupt handler
  rc=mcccommand(ENABLE.SMPTE.MSG)
  rc=mcccommand(DISABLE.ALL.THRU)
  rc=mcccommand(DISABLE.THRU)

  rc=mcccommand(SMPTE.MODE)
  rc=mcccommand(START.SMPTE.READ)

  while inkey$ = ""                     ' wait for key
    call smpteefw(VARPTR(efw%),VARPTR(smpteaddr))
    if efw% <> 0 then                    ' if a SMPTE frame address received *
      if running% = 0 then
        running%=1
        print "Press ESC to return"
      end if
      locate 12,1
      print asc(mid$(smpteaddr,1,1)) AND &h1F":"asc(mid$(smpteaddr,2,1))":"asc(mid$(smpteaddr,3,1))":" asc(mid$(smpteaddr,4,1))
    end if
    if strkendefw <> 0 then             ' check for end of track
      locate 16,31
      print "End of SMPTE Track"
    end if
  wend

  mccreset                              ' return to coproc mode *
end sub

'===================================*
'                                   *
' SMPTE cue point                   *
'                                   *
'===================================*
sub cuepoint
  DIM smpteaddr as string*4

  cls
  print "MCC/MQX-32 Programmer's ToolKit - SMPTE Cue Point Example"
  input "Enter cue point (hh,mm,ss,fr): ",hh%,mm%,ss%,fr%
  print "Cue point = ";hh%;":";mm%;":";ss%;":";fr%

  hh=hh OR &h60

  mccsetcoprocslih                      '* set up co-processor interrupt handler
  rc=mcccommand(DISABLE.ALL.THRU)
  rc=mcccommand(DISABLE.THRU)
  rc=mcccommand(ENABLE.SMPTE.MSG)       ' enable SMPTE frame messages *
  rc=mcccommand(SMPTE.CONTROL)          ' set up the cue point *
  mccput(SMPTE.CUE.POINT)
  mccput(hh%)
  mccput(mm%)
  mccput(ss%)
  mccput(fr%)

  rc=mcccommand(SMPTE.MODE)
  rc=mcccommand(START.SMPTE.READ)

  print "Please start the tape or ESC to return"
  running=0

  while inkey$ = ""                     ' wait for key
    call smpteefw(VARPTR(efw%),VARPTR(smpteaddr))
    if efw% <> 0 then                   ' if a SMPTE frame address received *
      if running% = 0 then
        running%=1
        print "Press ESC to return"
      end if
      locate 12,1
      print asc(mid$(smpteaddr,1,1)) AND &h1F":"asc(mid$(smpteaddr,2,1))":"asc(mid$(smpteaddr,3,1))":" asc(mid$(smpteaddr,4,1))
      if cuepointefw <> 0 then          ' look for cue point hit
        locate 14,1                     ' display frame address
        print "CUE POINT HIT!!"
      end if
    end if
    if strkendefw <> 0 then             ' check for end of track
      locate 16,31
      print "End of SMPTE Track"
    end if
  wend

  mccreset                              ' return to coproc mode *
end sub

'===================================*
'                                   *
' Write SMPTE track                 *
'                                   *
'===================================*
sub writesmpte
  DIM smpteaddr as string*4

  cls
  print "MCC/MQX-32 Programmer's ToolKit - Write SMPTE Track"
  input "Enter SMPTE origin (hh,mm,ss,fr): ",ohh%,omm%,oss%,ofr%
  input "How many minutes of tape (1-60): ",dur%

  ohh=ohh OR &h60                       ' force 30 frame non-drop *
  mm%=(omm+dur) MOD 60                  ' calc cue point for end *
  hh%=ohh+((omm+dur)\60)

  mccreset                              ' put MQX-32 into known state *
  mccsetcoprocslih                      '* set up co-processor interrupt handler

  rc=mcccommand(SMPTE.CONTROL)          ' set up the origin frame address *
  mccput(SMPTE.ORIGIN)
  mccput(ohh)
  mccput(omm)
  mccput(oss)
  mccput(ofr)
  rc=mcccommand(SMPTE.CONTROL)          ' set up the cue point *
  mccput(SMPTE.CUE.POINT)
  mccput(hh%)
  mccput(mm%)
  mccput(oss%)
  mccput(ofr%)

  print "Start the tape in record mode"
  print "Press any key when tape is running"
  while inkey$ = ""                     ' wait for key
  wend

  rc=mcccommand(SMPTE.MODE)             ' put the MQX-32 into SMPTE mode *
  rc=mcccommand(ENABLE.SMPTE.MSG)       ' enable SMPTE frame messages *
  rc=mcccommand(START.RECSMPTE)         ' start writing *

  print "Writing ";dur;" minutes of SMPTE track...press any key to stop"

  ' spin until end of time or asked to quit *
  while inkey$ = "" AND cuepointefw = 0
    call smpteefw(VARPTR(efw%),VARPTR(smpteaddr))
    if efw% <> 0 then                   ' if a SMPTE frame address received *
      locate 16,1
      print asc(mid$(smpteaddr,1,1)) AND &h1F":"asc(mid$(smpteaddr,2,1))":"asc(mid$(smpteaddr,3,1))":" asc(mid$(smpteaddr,4,1))
    end if
  wend

  rc=mcccommand(STOP.RECSMPTE)          ' stop writing *

  locate 18,1
  print "Sync track written....press any key to continue"
  while inkey$ = ""                     ' wait for key
  wend

  mccreset                              ' return to default mode *
end sub
