{ *************************************************************************************}
{ TSmartListView v1.01                                                                 }
{ *************************************************************************************}
{ Date last modified:  30/05/99                                                        }
{ -------------------------------------------------------------------------------------}
{ CopyRigth 1999 by Fabio De Pasquale                                                  }
{ depa@pronet.it                                                                       }
{ mes@freemail.it                                                                      }
{ Check for latest version at:                                                         }
{ http://members.xoom.com/MadElectron                                                  }
{ -------------------------------------------------------------------------------------}
{ This component can be freely used and distributed in commercial and private          }
{ environments, provided this notice is not modified in any way.                       }
{ I will appreciate an email if you like my component!                                 }
{ -------------------------------------------------------------------------------------}
{ Feel free to contact me if you have any questions, comments , suggestions or         }
{ bugs report at:                                                                      }
{ depa@pronet.it (Fabio De Pasquale)                                                   }
{ mes@freemail.it                                                                      }
{ -------------------------------------------------------------------------------------}
{ Description:                                                                         }
{   Component derived from TListView that allows to Load/Save items in a file.         }
{ Properties:                                                                          }
{   Msg1 : Message obtained when attempting to load a not existing file.               }
{   Msg2 : Message obtained when attempting to load not a SmartListView file type.     }
{ Procedures                                                                           }
{   procedure SaveToFile(FileName)                                                     }
{   procedure LoadFromFile(FileName)                                                   }
{ FileFormat                                                                           }
{   This is the format used to store ListView data in a file:                          }
{   FFF cc | sc ic Lc CC...C Ls SS...S  ...                                            }
{--Legend---------------------                                                         }
{   FFF 3 Byte  : Set to 'LVF' This is the sign of the SmartListView File. If you      }
{                try to load not a SmartListView file type you get an I/O error message}
{   cc  2 Byte : (word) The SmartListView.Items.Count                                  }
{   sc  2 Byte : (word) The SmartListView.Items[X].SubItems.Count                      }
{   ic  2 Byte : (word) The SmartListView.Items[X].ImageIndex                          }
{   Lc  2 byte : (word) The SmartListView.Items[X].Caption byte length                 }
{   CC...C     : Lc byte that make a string (The SmartListView.Items[X].Caption)       }
{   Ls  2 byte : (word) The SmartListView.Items[X].SubItems byte length                }
{   SS...S     : Ls byte that make a string (The SmartListView.Items[X].SubItems)      }
{   ...   and so on for all subitems of a single Item.                                 }
{ -------------------------------------------------------------------------------------}
{ Revision History:                                                                    }
{ 1.00:  + First public release                                                        }
{ 1.01:  + Bug fixed. When the SmartListView contained only one item with no           }
{          subitems, it wrote in the file a wrong number of subitems. As result        }
{          it performed the loading more then 65000 times. Sorry for that.             }
{        + Bug fixed. SmartListView can now save empty lists.                          }
{ -------------------------------------------------------------------------------------}
unit SmartListView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DsgnIntf;

type
  TAboutButtonProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

type
  TSmartListView = class(TListView)
  private
    { Private declarations }
    FAbout: TAboutButtonProperty;
    FMsg1 : String;
    FMsg2 : String;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure   SaveToFile(sFileName:String);
    procedure   LoadFromFile(sFileName:String);
  published
    { Published declarations }
    property Msg1: String read FMsg1 write FMsg1;
    property Msg2: String read FMsg2 write FMsg2;
    property About: TAboutButtonProperty read FAbout write FAbout;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TSmartListView]);
  RegisterPropertyEditor(TypeInfo(TAboutButtonProperty), TSmartListView, 'ABOUT', TAboutButtonProperty);
end;

constructor TSmartListView.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Msg1 := 'File "%s" does not exist!';
  Msg2 := '"%s" is not a ListView file!';
end;

destructor TSmartListView.Destroy;
begin
  inherited Destroy;
end;

procedure TSmartListView.SaveToFile(sFileName:String);
var  idxItem,idxSub,IdxImage : integer;
     F         : TFileStream;
     pText     : pChar;
     sText     : String;
     W,ItemCount,SubCount : word;
     MySignature : Array [0..2] of char;
begin
     //Initialization
     ItemCount:=0;
     SubCount:=0;
     //****
     MySignature := 'LVF'; //  ListViewFile
     F := TFileStream.Create(sFileName,fmCreate or fmOpenWrite);
     F.Write(MySignature,sizeof(MySignature));

     if Items.Count = 0 then
          // List is empty
          ItemCount := 0
     else
          ItemCount := Items.Count;
     F.Write( ItemCount,Sizeof( ItemCount ) );

     if Items.Count > 0 then
     begin
     for idxItem := 1 to ItemCount do
       begin
                 with items[idxItem - 1] do
                 begin
                       //Save subitems count
                       if SubItems.Count = 0 then
                          SubCount := 0
                       else
                          SubCount := Subitems.Count;
                       F.Write( SubCount,Sizeof( SubCount ) );
                       //Save ImageIndex
                       IdxImage := ImageIndex;
                       F.Write( IdxImage,Sizeof( IdxImage ) );
                       //Save Caption
                       sText := Caption;
                       w := length(sText);
                       pText := StrAlloc( Length( sText ) + 1);
                       StrPLCopy(pText,sText,Length( sText ) );
                       F.Write(w, sizeof(w));
                       F.Write(pText^,w);
                       StrDispose(pText);
                       if SubCount > 0 then
                       begin
                       for idxSub:=0 to SubItems.Count - 1 do
                           begin //Save Item's subitems
                            sText := SubItems[idxSub];
                            w := length(sText);
                            pText := StrAlloc( Length( sText ) + 1);
                            StrPLCopy(pText,sText,Length( sText ) );
                            F.Write(w, sizeof(w));
                            F.Write(pText^,w);
                            StrDispose(pText);
                            end;
                       end;
                 end;
       end;
     end;
     F.Free;
end;



procedure TSmartListView.LoadFromFile(sFileName:String);
var
   F:TFileStream;
   IdxItem,IdxSubItem, IdxImage : Integer;
   W,ItemCount,SubCount:Word;
   pText:pchar;
   PTemp:pChar;
   MySignature :  Array [0..2] of Char;
   sExeName:String;
  begin
    ItemCount:=0;
    SubCount:=0;

    sExeName := ExtractFileName(sFileName);

    if not FileExists( sFileName ) then
    begin
      MessageBox(Handle,pChar(format( Msg1,[sExeName])),'I/O Error',MB_ICONERROR);
      Exit;
    end;

    F:=TFileStream.Create(sFileName,fmOpenRead);

    F.Read(MySignature,sizeof(MySignature));

    if MySignature <> 'LVF' then
     begin
      MessageBox(Handle,pChar(format(Msg2,[sExeName])),'I/O Error',MB_ICONERROR);
      Exit;
     end;

    F.Read(ItemCount,sizeof(ItemCount));

    Items.Clear;

    For idxItem := 1 to ItemCount do
      begin
        with Items.Add do
        begin
             //Read imageindex
             F.Read( SubCount,sizeof( SubCount ) );
             //Read imageindex
             F.Read( IdxImage,sizeof( IdxImage ) );
             ImageIndex := IdxImage;
             //Read the Caption
             F.Read(w,SizeOf(w));
             pText:=StrAlloc(w + 1);
             pTemp:=StrAlloc(w + 1);
             F.Read(pTemp^,W);
             StrLCopy(pText,pTemp,W);
             Caption := StrPas(pText);
             StrDispose(pTemp);
             StrDispose(pText);
             if SubCount > 0 then
             begin
             for idxSubItem:=1 to SubCount do
                 begin
                 F.Read(w,SizeOf(w));
                 pText:=StrAlloc(w + 1);
                 pTemp:=StrAlloc(w + 1);
                 F.Read(pTemp^,W);
                 StrLCopy(pText,pTemp,W);
                 Items[idxItem - 1].SubItems.Add( StrPas(pText) );
                 StrDispose(pTemp);
                 StrDispose(pText);
                 end;
             end;    
         end;
      end;
    
   F.Free;
end;

procedure TAboutButtonProperty.Edit;
var
   AboutTitle,
   AboutDesc: String;
begin
   AboutTitle := 'About TSmartListView';
   AboutDesc := 'TSmartListView (Version 1.01)'+
   ^M^M+'Copyright  1999 by Fabio De Pasquale'+
   ^M+ '<depa@pronet.it>'+
   ^M+ '<mes@freemail.it>' +
   ^M+ 'Check "http://members.xoom.com/MadElectron"'+
   ^M+ 'for latest version.';

   Application.MessageBox(PChar(AboutDesc), PChar(AboutTitle), MB_OK+ MB_ICONINFORMATION);
end;

function TAboutButtonProperty.GetAttributes: TPropertyAttributes;
begin
 	Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutButtonProperty.GetValue: string;
begin
	Result := '(About)';
end;


end.
