{
    SettingsWin1.pas - Settings window
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit SettingsWin1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Defines, SRGrad, dcmemopt, dcenvopt;

type
  TSettingsWin = class(TForm)
    PageControl1: TPageControl;
    GeneralSheet: TTabSheet;
    Panel1: TPanel;
    OKBut: TButton;
    CancelBut: TButton;
    ResetWindowLocsBut: TButton;
    Label1: TLabel;
    ResourceNameTypeCombo: TComboBox;
    Label2: TLabel;
    DefaultResourceTypeCombo: TComboBox;
    LogEditSheet: TTabSheet;
    MaximizeEditorWindowCheckBox: TCheckBox;
    ShowAllMessagesCheckBox: TCheckBox;
    ShowAllElsesAsGotosCheckBox: TCheckBox;
    ShowSpecialSyntaxCheckBox: TCheckBox;
    DefaultBut: TButton;
    ShowSplashScreenCheckBox: TCheckBox;
    SRGradient5: TSRGradient;
    ButtonAdvancedLogicSettings: TButton;
    procedure CancelButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DefaultButClick(Sender: TObject);
    procedure OKButClick(Sender: TObject);
    procedure ResetWindowLocsButClick(Sender: TObject);
    procedure ResourceNameTypeComboChange(Sender: TObject);
    procedure DefaultResourceTypeComboChange(Sender: TObject);
    procedure MaximizeEditorWindowCheckBoxClick(Sender: TObject);
    procedure ShowAllMessagesCheckBoxClick(Sender: TObject);
    procedure ShowAllElsesAsGotosCheckBoxClick(Sender: TObject);
    procedure ShowSpecialSyntaxCheckBoxClick(Sender: TObject);
    procedure ShowSplashScreenCheckBoxClick(Sender: TObject);
    procedure ButtonAdvancedLogicSettingsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SettingsWin: TSettingsWin;
  NewSettings : TSettings;

implementation

uses main1, ResourceWin1, PreviewWin1, LogEdit1;

{$R *.DFM}

procedure TSettingsWin.CancelButClick(Sender: TObject);
begin
  Close;
end;

procedure TSettingsWin.FormShow(Sender: TObject);
begin
  NewSettings := Settings;
  ResourceNameTypeCombo.ItemIndex := NewSettings.Resources.NameType;
  DefaultResourceTypeCombo.ItemIndex := NewSettings.Resources.DefaultType;
  MaximizeEditorWindowCheckBox.Checked := NewSettings.LogicEditor.MaximizeEditorWindow;
  ShowAllMessagesCheckBox.Checked := NewSettings.LogicEditor.ShowAllMessages;
  ShowAllElsesAsGotosCheckBox.Checked := NewSettings.LogicEditor.ShowAllElsesAsGotos;
  ShowSpecialSyntaxCheckBox.Checked := NewSettings.LogicEditor.ShowSpecialSyntax;
  ShowSplashScreenCheckBox.Checked := NewSettings.General.ShowSplashScreen;
end;

procedure TSettingsWin.DefaultButClick(Sender: TObject);
begin
  NewSettings.Resources := DefaultSettings.Resources;
  NewSettings.LogicEditor := DefaultSettings.LogicEditor;
  ResourceNameTypeCombo.ItemIndex := NewSettings.Resources.NameType;
  DefaultResourceTypeCombo.ItemIndex := NewSettings.Resources.DefaultType;
  MaximizeEditorWindowCheckBox.Checked := NewSettings.LogicEditor.MaximizeEditorWindow;
  ShowAllMessagesCheckBox.Checked := NewSettings.LogicEditor.ShowAllMessages;
  ShowAllElsesAsGotosCheckBox.Checked := NewSettings.LogicEditor.ShowAllElsesAsGotos;
  ShowSpecialSyntaxCheckBox.Checked := NewSettings.LogicEditor.ShowSpecialSyntax;
  ShowSplashScreenCheckBox.Checked := NewSettings.General.ShowSplashScreen;
end;

procedure TSettingsWin.OKButClick(Sender: TObject);
var UpdateResourceNames : boolean;
begin
  UpdateResourceNames := NewSettings.Resources.NameType <> Settings.Resources.NameType;

  Settings := NewSettings;

  if UpdateResourceNames then
  begin
    SetResTypeName2;
    if GameIsOpen then
    begin
      ResourceWin.ResTypeSelect.Items.Assign(ResTypeName2);
      ResourceWin.ResTypeSelect.ItemIndex := SelectedResourceType;
      ResourceWin.DisplayResourceList;
    end;
  end;

  Close;
end;

procedure TSettingsWin.ResetWindowLocsButClick(Sender: TObject);
begin
  Main.WindowState := wsNormal;
  Main.Top := Main.DefaultTop;
  Main.Left := Main.DefaultLeft;
  Main.Width := Main.DefaultWidth;
  Main.Height := Main.DefaultHeight;
  if GameIsOpen then
  begin
    ResourceWin.WindowState := wsNormal;
    ResourceWin.Top := 0;
    ResourceWin.Left := 0;
    ResourceWin.ClientWidth := ResourceWin.DefaultClientWidth;
    PreviewWin.WindowState := wsNormal;
    PreviewWin.Top := 0;
    PreviewWin.Left := ResourceWin.Width;
    PreviewWin.ClientWidth := PreviewWin.DefaultClientWidth;
    PreviewWin.ClientHeight := PreviewWin.DefaultClientHeight;
    ResourceWin.Height := PreviewWin.Height;
  end
  else
  begin
    Settings.Windows.ResourceWin.Maximized := False;
    Settings.Windows.ResourceWin.Top := 0;
    Settings.Windows.ResourceWin.Left := 0;
    Settings.Windows.ResourceWin.Width := -1;
    Settings.Windows.ResourceWin.Height := -1;
  end;
  SettingsWin.SetFocus;
end;

procedure TSettingsWin.ResourceNameTypeComboChange(Sender: TObject);
begin
  NewSettings.Resources.NameType := ResourceNameTypeCombo.ItemIndex;
end;

procedure TSettingsWin.DefaultResourceTypeComboChange(Sender: TObject);
begin
  NewSettings.Resources.DefaultType := DefaultResourceTypeCombo.ItemIndex;
end;

procedure TSettingsWin.MaximizeEditorWindowCheckBoxClick(Sender: TObject);
begin
  NewSettings.LogicEditor.MaximizeEditorWindow := MaximizeEditorWindowCheckBox.Checked;
end;

procedure TSettingsWin.ShowAllMessagesCheckBoxClick(Sender: TObject);
begin
  NewSettings.LogicEditor.ShowAllMessages := ShowAllMessagesCheckBox.Checked;
end;

procedure TSettingsWin.ShowAllElsesAsGotosCheckBoxClick(Sender: TObject);
begin
  NewSettings.LogicEditor.ShowAllElsesAsGotos := ShowAllElsesAsGotosCheckBox.Checked;
end;

procedure TSettingsWin.ShowSpecialSyntaxCheckBoxClick(Sender: TObject);
begin
  NewSettings.LogicEditor.ShowSpecialSyntax := ShowSpecialSyntaxCheckBox.Checked;
end;

procedure TSettingsWin.ShowSplashScreenCheckBoxClick(Sender: TObject);
begin
  NewSettings.General.ShowSplashScreen := ShowSplashScreenCheckBox.Checked;
end;

procedure TSettingsWin.ButtonAdvancedLogicSettingsClick(Sender: TObject);
begin
  // We'll use the DreamCom Editor Options form instead of the one I made
  ShowEnvironmentOptions;
end;

end.
