/////////////////////////////////////////////////////
//
// BLGExceptions.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    declaration of the exception types that might
//    be thrown by classes in the Base Logic Generator
//
// Portability information:
//    the code in this file should be portable without
//    much trouble
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(BLG_EXCEPTIONS_H_INCLUDED)
#define BLG_EXCEPTIONS_H_INCLUDED

#include <exception>

/////////////////////////////////////////////////////
//
// class CArrayIndexOutOfBoundsException
//
// Basic idea:
//    thrown when a request is made to set or retrieve
//    the value of an array element that is beyond the
//    end of an array
//
/////////////////////////////////////////////////////

class CArrayIndexOutOfBoundsException : public exception
{
public:
    CArrayIndexOutOfBoundsException(const char *psz = 
        "array index out of bounds") : exception(psz)
    {
    }

    virtual ~CArrayIndexOutOfBoundsException()
    {
    }
};

/////////////////////////////////////////////////////
//
// class COpenClipboardFailedException
//
// Basic idea:
//    thrown when a request is made to write to the
//    clipboard mechanism, and the mechanism cannot
//    be used
//
/////////////////////////////////////////////////////

class COpenClipboardFailedException : public exception
{
public:
    COpenClipboardFailedException(const char *psz =
        "could not open clipboard")
        : exception(psz)
    {
    }

    virtual ~COpenClipboardFailedException()
    {
    }
};

/////////////////////////////////////////////////////
//
// class CMallocFailedException
//
// Basic idea:
//    thrown when a memory allocation operation fails
//
/////////////////////////////////////////////////////

class CMallocFailedException : public exception
{
public:
    CMallocFailedException(const char *psz = "memory allocation failed") :
      exception(psz)
    {
    }

    virtual ~CMallocFailedException()
    {
    }
};

/////////////////////////////////////////////////////
//
// class CPersistentDataLoadFailureException
//
// Basic idea:
//    thrown when there is a problem reading the BLG's
//    persistent data
//
/////////////////////////////////////////////////////

class CPersistentDataLoadFailureException : public exception
{
public:
    CPersistentDataLoadFailureException(
        const char *psz = "could not load settings") : exception(psz)
    {
    }

    virtual ~CPersistentDataLoadFailureException()
    {
    }
};


#endif // !defined(BLG_EXCEPTIONS_H_INCLUDED)