/////////////////////////////////////////////////////
//
// Clipboard.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    provides an interface to a clipboard mechanism
//    for transferring data between applications
//
// Portability information:
//    one of the points of having this file is to
//    make the clipboard mechanism a little more
//    abstract -- a port to a different operating
//    system should only have to provide a different
//    implementation for WriteTextToClipboard in
//    order to support a clipboard mechanism
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(CLIPBOARD_H_INCLUDED)
#define CLIPBOARD_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// WriteToClipboardSupported
//
/////////////////////////////////////////////////////
//
// Purpose:
//    indicates whether the current build of the
//    software supports the clipboard mechanism; this
//    is used by the source code generation module
//    to determine whether a write to the clipboard
//    is possible; it may also be used by the user
//    interface to determine whether the option
//    of writing to the clipboard may be selected
//    as the only means of generating a source file
// Return value:
//    TRUE if the clipboard mechanism is supported;
//    FALSE if it is not
//
/////////////////////////////////////////////////////

BOOL WriteToClipboardSupported();

/////////////////////////////////////////////////////
//
// WriteTextToClipboard
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides an abstraction of the clipboard
//    mechanism so that the source code generation
//    module doesn't have to worry about the specifics
//    of how a particular operating system's clipboard
//    mechanism is used
// Parameter pszText:
//    a pointer to a null-terminated string that is
//    to be written to the clipboard; must not be
//    NULL
//
/////////////////////////////////////////////////////

void WriteTextToClipboard(PSTR pszText);

#endif !defined(CLIPBOARD_H_INCLUDED)