/////////////////////////////////////////////////////
//
// CommentsDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the Comments property page's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(COMMENTS_DLG_EVENT_HANDLERS_H_INCLUDED)
#define COMMENTS_DLG_EVENT_HANDLERS_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Comments property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Comments property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMNotify
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_NOTIFY handler for the Comments property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_NOTIFY message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_NOTIFY message
// Parameter lParam:
//    the lParam sent with the WM_NOTIFY message
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgWMNotify(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(COMMENTS_DLG_EVENT_HANDLERS_H_INCLUDED)