/////////////////////////////////////////////////////
//
// CommentsDlgUI.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for comments property page's
//    user interface functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(COMMENTS_DLG_UI_H_INCLUDED)
#define COMMENTS_DLG_UI_H_INCLUDED

#include "BLGDefs.h"

// this constant just defines the length of the string that
// contains the contents of the comment sample window
#define MAX_COMMENT_SAMPLE_LEN 500

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboHeaderComment
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications from the Header Comment
//    combo box
// Parameter wParam:
//    the wParam value that contains the notification
//    code indicating what type of event has occurred
// Return value:
//    TRUE if the event is handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboHeaderComment(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboHeaderCommentCBNSelChange
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the CBN_SELCHANGE notification for
//    the Header Comment combo box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboHeaderCommentCBNSelChange();

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboOneLineComment
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications from the One Line Comment
//    combo box
// Parameter wParam:
//    the wParam value that contains the notification
//    code indicating what type of event has occurred
// Return value:
//    TRUE if the event is handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboOneLineComment(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboOneLineCommentCBNSelChange
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the CBN_SELCHANGE notification for
//    the Header Comment combo box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboOneLineCommentCBNSelChange();

/////////////////////////////////////////////////////
//
// UpdateCommentSample
//
/////////////////////////////////////////////////////
//
// Purpose:
//    refreshes the comment sample window; should
//    be called when other events cause a change
//    in settings that are sampled in the sample window
//
/////////////////////////////////////////////////////

void UpdateCommentSample();

#endif // !defined(COMMENTS_DLG_UI_H_INCLUDED)