/////////////////////////////////////////////////////
//
// CommentsPropSheetPage.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the property page procedure and
//    dialog box procedure for the Comments property
//    page; these need to be prototypes because the
//    code that sets up the options dialog needs to
//    mention these functions when building the
//    property sheet
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(COMMENTS_PROP_SHEET_PAGE_H_INCLUDED)
#define COMMENTS_PROP_SHEET_PAGE_H_INCLUDED

#include "BLGDefs.h"
// prsht.h is needed for property sheet stuff
#include <prsht.h>

/////////////////////////////////////////////////////
//
// CommentsPageProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    property page procedure for the Comments property
//    page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    tell ya the truth, I don't really know what it's
//    for
//
/////////////////////////////////////////////////////

UINT CALLBACK CommentsPageProc(HWND hwnd, UINT uiMsg, LPPROPSHEETPAGE ppsp);

/////////////////////////////////////////////////////
//
// CommentsDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Comments property page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK CommentsDlgProc(HWND hDlg, UINT uiMsg, 
                              WPARAM wParam, LPARAM lParam);

#endif // !defined(COMMENTS_PROP_SHEET_PAGE_H_INCLUDED)