/////////////////////////////////////////////////////
//
// CompiledCodeDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the Compiled Code property page's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(COMPILED_CODE_DLG_EVENT_HANDLERS_H_INCLUDED)
#define COMPILED_CODE_DLG_EVENT_HANDLERS_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// OnCompiledCodeDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Compiled code
//    property page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnCompiledCodeDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMNotify
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_NOTIFY handler for the Compiled Code property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_NOTIFY message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_NOTIFY message
// Parameter lParam:
//    the lParam sent with the WM_NOTIFY message
//
/////////////////////////////////////////////////////

BOOL OnCompiledCodeDlgWMNotify(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(COMPILED_CODE_DLG_EVENT_HANDLERS_H_INCLUDED)