/////////////////////////////////////////////////////
//
// DefineNameDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the 
//    Define Name dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "DefineNameList.h"
#include "GeneralUI.h"
#include "DefineNameDlgUI.h"
#include "DefineNameDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

HWND g_hwndDefineNameDlg;

/////////////////////////////////////////////////////
// defined in DefineNameDlg.cpp
extern CDefineNameList g_deflistTemp;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in DefineNameDlgUI.cpp
extern int g_nPrevDefTypeSel;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnDefineNameDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Define Name dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnDefineNameDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_LIST_DEFINED_NAMES:
        return OnListDefinedNames(wParam);
    case IDC_COMBO_DEFINE_TYPE:
        return OnComboDefineType(wParam);
    case IDC_BUTTON_EDIT_DEFINE:
        return OnButtonEditDefine();
    case IDOK:
        return OnDefineNameDlgOK();
    case IDCANCEL:
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnDefineNameDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Define Name dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnDefineNameDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    HWND hwndControl;
    char szBuffer[MAX_DEFINE_NAME_LEN + 1];

    g_hwndDefineNameDlg = hDlg;

    CenterDialogToParent(hDlg);

    hwndControl = GetDlgItem(hDlg, IDC_COMBO_DEFINE_TYPE);
    ComboBoxAddString(hDlg, IDC_COMBO_DEFINE_TYPE, "Vars");
    ComboBoxAddString(hDlg, IDC_COMBO_DEFINE_TYPE, "Flags");
    ComboBoxAddString(hDlg, IDC_COMBO_DEFINE_TYPE, "Strings");
    ComboBoxAddString(hDlg, IDC_COMBO_DEFINE_TYPE, "Constants");
    ComboBoxAddString(hDlg, IDC_COMBO_DEFINE_TYPE, "Objects");

    SendMessage(hwndControl, CB_SETCURSEL, 0, 0);
    g_nPrevDefTypeSel = 0;

    for (ULONG ul = 0; ul < RESERVED_VAR_COUNT; ul++)
    {
        g_deflistTemp.GetVarName(ul, szBuffer, MAX_DEFINE_NAME_LEN + 1);
        ListBoxAddString(hDlg, IDC_LIST_DEFINED_NAMES, szBuffer);
    }

    return TRUE;
}