/////////////////////////////////////////////////////
//
// DefineNameDlgUI.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for Define Name dialog's user 
//    interface functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(DEFINE_NAME_DLG_UI_H_INCLUDED)
#define DEFINE_NAME_DLG_UI_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// OnListDefinedNames
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications from the Defined Names
//    list box
// Parameter wParam:
//    the wParam value that contains the notification
//    code indicating what type of event has occurred
// Return value:
//    TRUE if the event is handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnListDefinedNames(WPARAM wParam);

BOOL OnListDefinedNamesLBNSelChange();

BOOL OnListDefinedNamesLBNDblClick();

void EnableEditButton(BOOL bEnable = TRUE);

/////////////////////////////////////////////////////
//
// OnComboDefineType
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications from the Define Type 
//    combo box
// Parameter wParam:
//    the wParam value that contains the notification
//    code indicating what type of event has occurred
// Return value:
//    TRUE if the event is handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnComboDefineType(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnComboDefineTypeCBNSelChange
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the CBN_SELCHANGE notification for
//    the Define Type combo box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnComboDefineTypeCBNSelChange();

/////////////////////////////////////////////////////
//
// OnButtonEditDefine
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events for the Edit Define button
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnButtonEditDefine();

/////////////////////////////////////////////////////
//
// OnDefineNameDlgOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles event for the Define Name dialog's
//    OK button
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnDefineNameDlgOK();

#endif // !defined(DEFINE_NAME_DLG_UI_H_INCLUDED)