/////////////////////////////////////////////////////
//
// EdgeCodeAdvancedDlg.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the Edge Code
//    Advanced dialog and contains its dialog box
//    procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "EdgeCodeAdvancedDlgEventHandlers.h"
#include "EdgeCodeAdvancedDlg.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in MainDlgEventHandlers.h
extern HWND g_hwndMainDlg;
/////////////////////////////////////////////////////

// this variable should not be modified outside of
// the EdgeCodeAdvancedDlg source files
CEdgeCodeInfo g_ecinfoTemp;

/////////////////////////////////////////////////////
//
// EdgeCodeAdvancedDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Edge Code Advanced dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK EdgeCodeAdvancedDlgProc(HWND hDlg, UINT uiMsg,
                                      WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnEdgeCodeAdvancedDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnEdgeCodeAdvancedDlgWMInitDialog(hDlg, wParam, lParam);
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// EdgeCodeAdvancedDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Edge Code Advanced dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter hwndParent:
//    the parent window for the Edge Code Advanced dialog;
//    while the Edge Code Advanced dialog is displayed, the
//    user is prevented from interacting with the parent
//    window
// Parameter ecinfo:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int EdgeCodeAdvancedDlgDoModal(CEdgeCodeInfo& ecinfo)
{
    int nResult;

    g_ecinfoTemp.BecomeCopy(&ecinfo);

    nResult = DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DLG_EDGE_CODE_ADV),
                        g_hwndMainDlg, EdgeCodeAdvancedDlgProc);

    if (nResult == IDOK)
    {
        ecinfo.BecomeCopy(&g_ecinfoTemp);
    }

    return nResult;
}