/////////////////////////////////////////////////////
//
// EdgeCodeAdvancedDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the 
//    Edge Code Advanced dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "EdgeCodeAdvancedDlgUI.h"
#include "EdgeCodeAdvancedDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

HWND g_hwndEdgeCodeAdvancedDlg;

extern CEdgeCodeInfo g_ecinfoTemp;

/////////////////////////////////////////////////////
//
// OnEdgeCodeAdvancedDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Edge Code Advanced dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEdgeCodeAdvancedDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_CHECK_EMPTY_CODE_LEFT_EDGE:
        return OnCheckEmptyCodeLeftEdge();
    case IDC_CHECK_EMPTY_CODE_RIGHT_EDGE:
        return OnCheckEmptyCodeRightEdge();
    case IDC_CHECK_EMPTY_CODE_BOTTOM_EDGE:
        return OnCheckEmptyCodeBottomEdge();
    case IDC_CHECK_EMPTY_CODE_HORIZON_EDGE:
        return OnCheckEmptyCodeHorizonEdge();
    case IDC_EDIT_LEFT_EDGE_MSG:
        return OnEditLeftEdgeMsg(wParam);
    case IDC_EDIT_RIGHT_EDGE_MSG:
        return OnEditRightEdgeMsg(wParam);
    case IDC_EDIT_BOTTOM_EDGE_MSG:
        return OnEditBottomEdgeMsg(wParam);
    case IDC_EDIT_HORIZON_EDGE_MSG:
        return OnEditHorizonEdgeMsg(wParam);
    case IDOK:
        return OnEdgeCodeAdvancedDlgOK();
    case IDCANCEL:
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
    }
    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnEdgeCodeAdvancedDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Edge Code Advanced
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEdgeCodeAdvancedDlgWMInitDialog(HWND hDlg, WPARAM wParam,
                                       LPARAM lParam)
{
    g_hwndEdgeCodeAdvancedDlg = hDlg;

    CenterDialogToParent(hDlg);
    
    HWND hwndControl;

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_LEFT_EDGE_MSG);
    SendMessage(hwndControl, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_PRINT_MSG_LEN), 0);

    if (!g_ecinfoTemp.m_bEmptyLeft)
    {
        SetWindowText(hwndControl, g_ecinfoTemp.m_szLeftMessage);
    }
    else
    {
        SetWindowText(hwndControl, "");
        EnableWindow(hwndControl, FALSE);
    }

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_RIGHT_EDGE_MSG);
    SendMessage(hwndControl, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_PRINT_MSG_LEN), 0);

    if (!g_ecinfoTemp.m_bEmptyRight)
    {
        SetWindowText(hwndControl, g_ecinfoTemp.m_szRightMessage);
    }
    else
    {
        SetWindowText(hwndControl, "");
        EnableWindow(hwndControl, FALSE);
    }

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_BOTTOM_EDGE_MSG);
    SendMessage(hwndControl, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_PRINT_MSG_LEN), 0);

    if (!g_ecinfoTemp.m_bEmptyBottom)
    {
        SetWindowText(hwndControl, g_ecinfoTemp.m_szBottomMessage);
    }
    else
    {
        SetWindowText(hwndControl, "");
        EnableWindow(hwndControl, FALSE);
    }

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_HORIZON_EDGE_MSG);
    SendMessage(hwndControl, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_PRINT_MSG_LEN), 0);

    if (!g_ecinfoTemp.m_bEmptyHorizon)
    {
        SetWindowText(hwndControl, g_ecinfoTemp.m_szHorizonMessage);
    }
    else
    {
        SetWindowText(hwndControl, "");
        EnableWindow(hwndControl, FALSE);
    }

    TryToEnableEmptyCodeLeftEdge();
    TryToEnableEmptyCodeRightEdge();
    TryToEnableEmptyCodeBottomEdge();
    TryToEnableEmptyCodeHorizonEdge();

    hwndControl = GetDlgItem(hDlg, IDC_CHECK_EMPTY_CODE_LEFT_EDGE);
    SetCheckboxChecked(hDlg, IDC_CHECK_EMPTY_CODE_LEFT_EDGE,
                       IsWindowEnabled(hwndControl) && 
                       g_ecinfoTemp.m_bEmptyLeft);

    hwndControl = GetDlgItem(hDlg, IDC_CHECK_EMPTY_CODE_RIGHT_EDGE);
    SetCheckboxChecked(hDlg, IDC_CHECK_EMPTY_CODE_RIGHT_EDGE,
                       IsWindowEnabled(hwndControl) &&
                       g_ecinfoTemp.m_bEmptyRight);

    hwndControl = GetDlgItem(hDlg, IDC_CHECK_EMPTY_CODE_BOTTOM_EDGE);
    SetCheckboxChecked(hDlg, IDC_CHECK_EMPTY_CODE_BOTTOM_EDGE,
                       IsWindowEnabled(hwndControl) && 
                       g_ecinfoTemp.m_bEmptyBottom);

    hwndControl = GetDlgItem(hDlg, IDC_CHECK_EMPTY_CODE_HORIZON_EDGE);
    SetCheckboxChecked(hDlg, IDC_CHECK_EMPTY_CODE_HORIZON_EDGE,
                       IsWindowEnabled(hwndControl) &&
                       g_ecinfoTemp.m_bEmptyHorizon);

    return TRUE;
}
