/////////////////////////////////////////////////////
//
// EdgeCodeAdvancedDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the Edge Code Advanced dialog's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(EDGE_CODE_ADVANCED_DLG_EVENT_HANDLERS_H_INCLUDED)
#define EDGE_CODE_ADVANCED_DLG_EVENT_HANDLERS_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// OnEdgeCodeAdvancedDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Edge Code Advanced dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEdgeCodeAdvancedDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnEdgeCodeAdvancedDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Edge Code Advanced
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEdgeCodeAdvancedDlgWMInitDialog(HWND hDlg, WPARAM wParam,
                                       LPARAM lParam);

#endif // !defined(EDGE_CODE_ADVANCED_DLG_EVENT_HANDLERS_H_INCLUDED)