/////////////////////////////////////////////////////
//
// EditDefineNameDlg.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the Edit Define
//    Name dialog and contains its dialog box
//    procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <cassert>
#include "resource.h"
#include "BLGDefs.h"
#include "EditDefineNameDlgEventHandlers.h"
#include "EditDefineNameDlg.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in DefineNameDlgEventHandlers.cpp
extern HWND g_hwndDefineNameDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

char g_szDefineNameTemp[MAX_DEFINE_NAME_LEN + 1];

/////////////////////////////////////////////////////
//
// EditDefineNameDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Edit Define Name dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK EditDefineNameDlgProc(HWND hDlg, UINT uiMsg, 
                                    WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnEditDefineNameDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnEditDefineNameDlgWMInitDialog(hDlg, wParam, lParam);
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// EditDefineNameDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Edit Define Name dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter hwndParent:
//    the parent window for the Edit Define Name dialog;
//    while the Edit Define Name dialog is displayed, the
//    user is prevented from interacting with the parent
//    window
// Parameter pszDefineName:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called; this parameter must not be NULL
//    and must be large enough to hold a string of
//    length MAX_DEFINE_NAME_LEN
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int EditDefineNameDlgDoModal(PSTR pszDefineName)
{
    int nResult;

    assert(pszDefineName != NULL);

    strncpy(g_szDefineNameTemp, pszDefineName, MAX_DEFINE_NAME_LEN + 1);

    nResult = DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DLG_EDIT_DEFINE_NAME),
                        g_hwndDefineNameDlg, EditDefineNameDlgProc);

    if (nResult == IDOK)
    {
        strncpy(pszDefineName, g_szDefineNameTemp, MAX_DEFINE_NAME_LEN + 1);
    }

    return nResult;
}
