/////////////////////////////////////////////////////
//
// EditDefineNameDlg.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    defines the public interface for the Edit
//    Define Name dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(EDIT_DEFINE_NAME_DLG_H_INCLUDED)
#define EDIT_DEFINE_NAME_DLG_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// EditDefineNameDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Edit Define Name dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter hwndParent:
//    the parent window for the Edit Define Name dialog;
//    while the Edit Define Name dialog is displayed, the
//    user is prevented from interacting with the parent
//    window
// Parameter pszDefineName:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called; this parameter must not be NULL
//    and must be large enough to hold a string of
//    length MAX_DEFINE_NAME_LEN
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int EditDefineNameDlgDoModal(PSTR pszDefineName);

#endif // !defined(EDIT_DEFINE_NAME_DLG_H_INCLUDED)