/////////////////////////////////////////////////////
//
// EntryLookDlg.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the Entry and Looking
//    dialog and contains its dialog box procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "EntryLookDlgEventHandlers.h"
#include "EntryLookDlg.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in MainDlgEventHandlers.cpp
extern HWND g_hwndMainDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

CEntryLookInfo g_elinfoTemp;

/////////////////////////////////////////////////////
//
// EntryLookDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Entry and Looking dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK EntryLookDlgProc(HWND hDlg, UINT uiMsg, 
                               WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnEntryLookDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnEntryLookDlgWMInitDialog(hDlg, wParam, lParam);
    }
    return FALSE;
}

/////////////////////////////////////////////////////
//
// EntryLookDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Entry and Looking dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter elinfo:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int EntryLookDlgDoModal(CEntryLookInfo& elinfo)
{
    int nResult;

    g_elinfoTemp.BecomeCopy(&elinfo);
    nResult = DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DLG_ENTRY_LOOK),
                        g_hwndMainDlg, EntryLookDlgProc);

    if (nResult == IDOK)
    {
        elinfo.BecomeCopy(&g_elinfoTemp);
    }

    return nResult;
}