/////////////////////////////////////////////////////
//
// EntryLookDlg.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    defines the public interface for the Entry
//    and Looking dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(ENTRY_LOOK_DLG_H_INCLUDED)
#define ENTRY_LOOK_DLG_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// EntryLookDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Entry and Looking dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

int EntryLookDlgDoModal(CEntryLookInfo& elinfo);

#endif // !defined(ENTRY_LOOK_DLG_H_INCLUDED)