/////////////////////////////////////////////////////
//
// EntryLookDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the Entry
//    and Looking dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <cstdio>
#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "EntryLookDlgUI.h"
#include "EntryLookDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in EntryLookDlg.cpp
extern CEntryLookInfo g_elinfoTemp;
/////////////////////////////////////////////////////

HWND g_hwndEntryLookDlg;

/////////////////////////////////////////////////////
//
// OnEntryLookDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Entry and Looking dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEntryLookDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDOK:
        return OnEntryLookDlgOK();
    case IDCANCEL:
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
    }
    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnEntryLookDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Entry and Looking
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEntryLookDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    HWND hwndEdit;

    CenterDialogToParent(hDlg);

    g_hwndEntryLookDlg = hDlg;

    hwndEdit = GetDlgItem(hDlg, IDC_EDIT_ENTRY_TEXT);
    SendMessage(hwndEdit, EM_SETLIMITTEXT, 
                static_cast<WPARAM>(MAX_PRINT_MSG_LEN), 0);
    SetWindowText(hwndEdit, g_elinfoTemp.m_szEntryMessage);

    hwndEdit = GetDlgItem(hDlg, IDC_EDIT_LOOK_TEXT);
    SendMessage(hwndEdit, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_PRINT_MSG_LEN), 0);
    SetWindowText(hwndEdit, g_elinfoTemp.m_szLookMessage);

    char szBuffer[MAX_WORD_GROUP_DIGITS + 1];

    sprintf(szBuffer, "%d", g_elinfoTemp.m_nLookWordGroup);

    hwndEdit = GetDlgItem(hDlg, IDC_EDIT_LOOK_GROUP);
    SendMessage(hwndEdit, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_WORD_GROUP_DIGITS), 0);
    SetWindowText(hwndEdit, szBuffer);

    return TRUE;
}
