/////////////////////////////////////////////////////
//
// EntryLookDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the Entry and Looking dialog's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(ENTRY_LOOK_DLG_EVENT_HANDLERS_H_INCLUDED)
#define ENTRY_LOOK_DLG_EVENT_HANDLERS_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnEntryLookDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Entry and Looking dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnEntryLookDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnEntryLookDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Entry and Looking
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnEntryLookDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(ENTRY_LOOK_DLG_EVENT_HANDLERS_H_INCLUDED)