/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlg.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the First Room Control
//    dialog and contains its dialog box procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "FirstRoomCtrlDlgEventHandlers.h"
#include "FirstRoomCtrlDlg.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in MainDlgEventHandlers.cpp
extern HWND g_hwndMainDlg;
/////////////////////////////////////////////////////

CFirstRoomCtrl g_frctrlTemp;

/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for the First Room Control
//    dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK FirstRoomCtrlDlgProc(HWND hDlg, UINT uiMsg,
                                   WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnFirstRoomCtrlDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnFirstRoomCtrlDlgWMInitDialog(hDlg, wParam, lParam);
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    First Room Control dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter frctrl:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int FirstRoomCtrlDlgDoModal(CFirstRoomCtrl& frctrl)
{
    int nResult;

    g_frctrlTemp.BecomeCopy(&frctrl);

    nResult = DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DLG_FIRST_ROOM_CTRL),
                        g_hwndMainDlg, FirstRoomCtrlDlgProc);

    if (nResult == IDOK)
    {
        frctrl.BecomeCopy(&g_frctrlTemp);
    }

    return nResult;
}