/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the First
//    Room Control dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <windows.h>
#include <cstdio>
#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "FirstRoomCtrlDlgUI.h"
#include "FirstRoomCtrlDlgEventHandlers.h"

/////////////////////////////////////////////////////
// defined in FirstRoomCtrlDlg.cpp
extern CFirstRoomCtrl g_frctrlTemp;
/////////////////////////////////////////////////////

HWND g_hwndFirstRoomCtrlDlg;

/////////////////////////////////////////////////////
//
// OnFirstRoomCtrlDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the First Room Control dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnFirstRoomCtrlDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDOK:
        return OnFirstRoomCtrlDlgOK();
    case IDCANCEL:
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnFirstRoomCtrlDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the First Room Control
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnFirstRoomCtrlDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    HWND hwndControl;
    char szBuffer[MAX_DIGITS + 1];

    CenterDialogToParent(hDlg);

    g_hwndFirstRoomCtrlDlg = hDlg;

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_X_POS);
    SendMessage(hwndControl, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_DIGITS), 0);

    if (g_frctrlTemp.m_nEgoX != NO_POS_X)
    {
        sprintf(szBuffer, "%d", g_frctrlTemp.m_nEgoX);
        SetWindowText(hwndControl, szBuffer);
    }

    hwndControl = GetDlgItem(hDlg, IDC_EDIT_Y_POS);
    SendMessage(hwndControl, EM_SETLIMITTEXT,
                static_cast<WPARAM>(MAX_DIGITS), 0);

    if (g_frctrlTemp.m_nEgoY != NO_POS_Y)
    {
        sprintf(szBuffer, "%d", g_frctrlTemp.m_nEgoY);
        SetWindowText(hwndControl, szBuffer);
    }

    SetCheckboxChecked(hDlg, IDC_CHECK_STATUS_BAR_ON,
                       g_frctrlTemp.m_bStatusBarOn);
    SetCheckboxChecked(hDlg, IDC_CHECK_ACCEPT_INPUT,
                       g_frctrlTemp.m_bAcceptInput);

    return TRUE;
}
