/////////////////////////////////////////////////////
//
// FirstRoomCtrlDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the First Room Control dialog's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(FIRST_ROOM_CTRL_DLG_EVENT_HANDLERS_H_INCLUDED)
#define FIRST_ROOM_CTRL_DLG_EVENT_HANDLERS_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnFirstRoomCtrlDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the First Room Control dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnFirstRoomCtrlDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnFirstRoomCtrlDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the First Room Control
//    dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnFirstRoomCtrlDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(FIRST_ROOM_CTRL_DLG_EVENT_HANDLERS_H_INCLUDED)