/////////////////////////////////////////////////////
//
// LogicGeneration.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    function protoypes and definition of constants
//    relevant to the generation of compiled AGI logic
//    code
//
// Portability information:
//    the code in this file should be portable without
//    much trouble
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(LOGIC_GENERATION_H_INCLUDED)
#define LOGIC_GENERATION_H_INCLUDED

// give symbolic names to the various AGI logic command bytes so that these
// obscure constants don't have to appear in the file generation code
#define LOGIC_CMD_START_IF   0xff
#define LOGIC_CMD_END_IF     0xff
#define LOGIC_CMD_ELSE       0xfe
#define LOGIC_CMD_GOTO       0xfe
#define LOGIC_CMD_NOT        0xfd
#define LOGIC_CMD_START_OR   0xfc
#define LOGIC_CMD_END_OR     0xfc

#define LOGIC_CMD_EQUALN          0x01
#define LOGIC_CMD_EQUALV          0x02
#define LOGIC_CMD_LESSN           0x03
#define LOGIC_CMD_LESSV           0x04
#define LOGIC_CMD_GREATERN        0x05
#define LOGIC_CMD_GREATERV        0x06
#define LOGIC_CMD_ISSET           0x07
#define LOGIC_CMD_ISSETV          0x08
#define LOGIC_CMD_HAS             0x09
#define LOGIC_CMD_OBJ_IN_ROOM     0x0a
#define LOGIC_CMD_POSN            0x0b
#define LOGIC_CMD_CONTROLLER      0x0c
#define LOGIC_CMD_HAVE_KEY        0x0d
#define LOGIC_CMD_SAID            0x0e
#define LOGIC_CMD_COMPARE_STRINGS 0x0f
#define LOGIC_CMD_OBJ_IN_BOX      0x10
#define LOGIC_CMD_CENTER_POSN     0x11
#define LOGIC_CMD_RIGHT_POSN      0x12

#define LOGIC_CMD_RETURN         0x00
#define LOGIC_CMD_ASSIGNN        0x03
#define LOGIC_CMD_NEW_ROOM       0x12
#define LOGIC_CMD_LOAD_PIC       0x18
#define LOGIC_CMD_DRAW_PIC       0x19
#define LOGIC_CMD_SHOW_PIC       0x1a
#define LOGIC_CMD_DISCARD_PIC    0x1b
#define LOGIC_CMD_DRAW           0x23
#define LOGIC_CMD_POSITION       0x25
#define LOGIC_CMD_SET_HORIZON    0x3f
#define LOGIC_CMD_PRINT          0x65
#define LOGIC_CMD_STATUS_LINE_ON 0x70
#define LOGIC_CMD_ACCEPT_INPUT   0x78

// the maximum size for a compiled logic file...gives plenty of padding;
// most generated files will fall well short of this number of bytes
#define MAX_LOGIC_DATA_SIZE 5000

/////////////////////////////////////////////////////
//
// GenerateCompiledLogic
//
/////////////////////////////////////////////////////
//
// Purpose:
//    the main function that should be called upon to
//    generate a compiled AGI logic file -- takes care
//    of the details of where the logic should be written
//    based on the options that have already been set
// Parameter pszGameDir:
//    the directory where the file should be written;
//    must not be NULL
//
/////////////////////////////////////////////////////

void GenerateCompiledLogic(PSTR pszGameDir);

#endif // !defined(LOGIC_GENERATION_H_INCLUDED)