/////////////////////////////////////////////////////
//
// MainDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the main BLG dialog's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(MAIN_DLG_EVENT_HANDLERS_H_INCLUDED)
#define MAIN_DLG_EVENT_HANDLERS_H_INCLUDED

#include <windows.h>

// used to add an "About" option to the system menu
#define IDM_SYS_ABOUT 1

/////////////////////////////////////////////////////
//
// OnMainDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the main BLG dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnMainDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnMainDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the main BLG dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnMainDlgWMInitDialog(HWND hDlg,WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnMainDlgWMSysCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_SYSCOMMAND handler for the main BLG dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_SYSCOMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_SYSCOMMAND message
// Parameter lParam:
//    the lParam sent with the WM_SYSCOMMAND message
//
/////////////////////////////////////////////////////

BOOL OnMainDlgWMSysCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(MAIN_DLG_EVENT_HANDLERS_H_INCLUDED)