/////////////////////////////////////////////////////
//
// MainDlgUI.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for main BLG dialog's user 
//    interface functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(MAIN_DLG_UI_H_INCLUDED)
#define MAIN_DLG_UI_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnUseRoomNumPic
//
/////////////////////////////////////////////////////
//
// Purpose:
//    event handler for the Use room_no for pic
//    checkbox
// Return value:
//    TRUE if the function handled the event; FALSE
//    if Windows needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnUseRoomNumPic();

/////////////////////////////////////////////////////
//
// OnFirstRoom
//
/////////////////////////////////////////////////////
//
// Purpose:
//    event handler for the First Room checkbox
// Return value:
//    TRUE if the function handled the event; FALSE
//    if Windows needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnFirstRoom();

/////////////////////////////////////////////////////
//
// OnDrawEgoInitially
//
/////////////////////////////////////////////////////
//
// Purpose:
//    event handler for the Draw ego initially checkbox
// Return value:
//    TRUE if the function handled the event; FALSE
//    if Windows needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnDrawEgoInitially();

/////////////////////////////////////////////////////
//
// OnEditLogicNumber
//
/////////////////////////////////////////////////////
//
// Purpose:
//    event handler for the Logic number edit box
// Return value:
//    TRUE if the function handled the event; FALSE
//    if Windows needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditLogicNumber(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditLogicNumberENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles EN_UPDATE notifications from the Logic
//    Number edit box
// Return value:
//    TRUE if event handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnEditLogicNumberENUpdate();

/////////////////////////////////////////////////////
//
// OnAddPosControl
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Add button for positioning
//    controls
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnAddPosControl();

/////////////////////////////////////////////////////
//
// OnEditPosControl
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Edit button for positioning
//    controls
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnEditPosControl();

/////////////////////////////////////////////////////
//
// OnDelPosControl
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Delete button for positioning
//    controls
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnDelPosControl();

/////////////////////////////////////////////////////
//
// OnClearPosControls
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Delete All button for
//    positioning controls
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnClearPosControls();

/////////////////////////////////////////////////////
//
// OnListEgoPos
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the ego positioning
//    list box
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnListEgoPos(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnListEgoPosLBNSelChange
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the LBN_SELCHANGE notification for the
//    ego positioning list box
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnListEgoPosLBNSelChange();

/////////////////////////////////////////////////////
//
// OnListEgoPosLBNDblClk
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the LBN_DBLCLICK notification for the
//    ego positioning list box
// Return value:
//    TRUE if event handled; FALSE if Windows should
//    handle it
//
/////////////////////////////////////////////////////

BOOL OnListEgoPosLBNDblClk();

/////////////////////////////////////////////////////
//
// EnableEditPosControl
//
/////////////////////////////////////////////////////
//
// Purpose:
//    enables or disables the Edit button for the
//    ego positioning controls
// Parameter bEnable:
//    specifies whether to enable or disable the button
//
/////////////////////////////////////////////////////

void EnableEditPosControl(BOOL bEnable = TRUE);

/////////////////////////////////////////////////////
//
// EnableDelPosControl
//
/////////////////////////////////////////////////////
//
// Purpose:
//    enables or disables the Delete button for the
//    ego positioning controls
// Parameter bEnable:
//    specifies whether to enable or disable the button
//
/////////////////////////////////////////////////////

void EnableDelPosControl(BOOL bEnable = TRUE);


/////////////////////////////////////////////////////
//
// EnableClearPosControls
//
/////////////////////////////////////////////////////
//
// Purpose:
//    enables or disables the Delete All button for the
//    ego positioning controls
// Parameter bEnable:
//    specifies whether to enable or disable the button
//
/////////////////////////////////////////////////////

void EnableClearPosControls(BOOL bEnable = TRUE);

/////////////////////////////////////////////////////
//
// OnEdgeControlAdvanced
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Advanced button for the
//    edge code controls
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEdgeControlAdvanced();

/////////////////////////////////////////////////////
//
// OnButtonOptions
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Options button
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnButtonOptions();

/////////////////////////////////////////////////////
//
// OnButtonBrowseForGamePath
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Browse button for the
//    game path
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnButtonBrowseForGamePath();

/////////////////////////////////////////////////////
//
// OnButtonEnterLook
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Entry and Looking button
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnButtonEnterLook();

/////////////////////////////////////////////////////
//
// OnButtonFirstRoomControls
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the First Room Controls button
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnButtonFirstRoomControls();

/////////////////////////////////////////////////////
//
// OnMainDlgOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the OK button
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnMainDlgOK();

/////////////////////////////////////////////////////
//
// GetEdgeCodeGotoValues
//
/////////////////////////////////////////////////////
//
// Purpose:
//    retrieves the edge code goto values from the
//    four edge code edit boxes on the main dialog
//    and assigns their numeric values into the 
//    g_ecinfo object
//
/////////////////////////////////////////////////////

void GetEdgeCodeGotoValues();

/////////////////////////////////////////////////////
//
// OnMainDlgCancel
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Exit button for the main
//    BLG dialog
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    should handle it
//
/////////////////////////////////////////////////////

BOOL OnMainDlgCancel();

/////////////////////////////////////////////////////
//
// OnMainDlgSysAbout
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles selection of the about box item from the
//    system menu
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    should handle it
//
/////////////////////////////////////////////////////

BOOL OnMainDlgSysAbout();

#endif // !defined(MAIN_DLG_UI_H_INCLUDED)