/////////////////////////////////////////////////////
//
// PositionCtrlDlg.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the Position Control
//    dialog and contains its dialog box procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <cassert>
#include "resource.h"
#include "PositionCtrlDlgEventHandlers.h"
#include "PositionCtrlDlg.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in MainDlgEventHandlers.cpp
extern HWND g_hwndMainDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

// this variable should not be modified outside of
// the PositionCtrlDlg source files
BOOL g_bPositionCtrlDlgInEditMode;
// this variable should not be modified outside of
// the PositionCtrlDlg source files
EGOPOSITIONCONTROL g_epcTemp;

/////////////////////////////////////////////////////
//
// PositionCtrlDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for the Position Control
//    dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK PositionCtrlDlgProc(HWND hDlg, UINT uiMsg,
                                  WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnPositionCtrlDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnPositionCtrlDlgWMInitDialog(hDlg, wParam, lParam);
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// PositionCtrlDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Position Control dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter nMode:
//    either POSCTRLDLG_MODE_ADD or POSCTRLDLG_MODE_EDIT;
//    the primary difference between Add mode and Edit
//    mode is the window title on the dialog box;
//    additionally, in edit mode, the contents of the
//    parameter epc are used to initialize the dialog
//    box's controls
// Parameter epc:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls, if the dialog box
//    is in Edit mode; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int PositionCtrlDlgDoModal(int nMode,
                           EGOPOSITIONCONTROL& epc)
{
    int nResult;

    if (nMode == POSCTRLDLG_MODE_ADD)
    {
        g_bPositionCtrlDlgInEditMode = FALSE;
    }
    else if (nMode == POSCTRLDLG_MODE_EDIT)
    {
        g_bPositionCtrlDlgInEditMode = TRUE;
        memcpy(&g_epcTemp, &epc, sizeof(EGOPOSITIONCONTROL));
    }
    else
    {
        assert(FALSE);
    }

    nResult = DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DLG_EDIT_POS_CTRL),
                        g_hwndMainDlg, PositionCtrlDlgProc);

    if (nResult == IDOK)
    {
        // copy the values into epc
        memcpy(&epc, &g_epcTemp, sizeof(EGOPOSITIONCONTROL));
    }

    return nResult;
}