/////////////////////////////////////////////////////
//
// PositionCtrlDlgUI.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for Position Control dialog's user 
//    interface functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(POSITION_CTRL_DLG_UI_H_INCLUDED)
#define POSITION_CTRL_DLG_UI_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// OnIgnorePrevRoom
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the IDC_CHECK_IGNORE_PREV_ROOM
//    checkbox
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnIgnorePrevRoom();


/////////////////////////////////////////////////////
//
// OnEditSrcRoom
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_EDIT_SRC_ROOM
//    edit box
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditSrcRoom(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditSrcRoomENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    IDC_EDIT_SRC_ROOM edit box
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditSrcRoomENUpdate();

/////////////////////////////////////////////////////
//
// OnOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the OK button for the
//    Position Control dialog
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnOK();

/////////////////////////////////////////////////////
//
// TryToEnableOKButton
//
/////////////////////////////////////////////////////
//
// Purpose:
//    looks at the current state of input in the
//    dialog box and determine if it is appropriate
//    to enable the OK button (note that this function
//    does not bounds check, because disabling the OK
//    button for out-of-bounds values would just make
//    the user wonder what's going on)
//
/////////////////////////////////////////////////////

void TryToEnableOKButton();

/////////////////////////////////////////////////////
//
// OnEditEgoPosX
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_EDIT_EGO_POS_X
//    edit box
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditEgoPosX(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEdtiEgoPosXENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    IDC_EDIT_EGO_POS_X edit box
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditEgoPosXENUpdate();

/////////////////////////////////////////////////////
//
// OnEditEgoPosY
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_EDIT_EGO_POS_Y
//    edit box
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditEgoPosY(WPARAM wParam);

/////////////////////////////////////////////////////
//
// OnEditEgoPosYENUpdate
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the EN_UPDATE notification for the
//    IDC_EDIT_EGO_POS_Y edit box
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEditEgoPosYENUpdate();

#endif // !defined(POSITION_CTRL_DLG_UI_H_INCLUDED)