/////////////////////////////////////////////////////
//
// QuotesDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the Quotes
//    property page
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <cassert>
#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "QuotesDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in OptionsDlg.cpp
extern COptions g_optionsTemp;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnQuotesDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Quotes property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnQuotesDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    // nothing complex here...just determine which radio buttons to
    // set based on the user's options

    int nSetValue;

    switch(g_optionsTemp.m_nUnescapedQuoteResponse)
    {
    case OPT_UQR_ALWAYS_INCLUDE_QUOTES:
        nSetValue = IDC_RADIO_AGI_MSG_ADD_BACKSLASH;
        break;
    case OPT_UQR_ALWAYS_REMOVE_QUOTES:
        nSetValue = IDC_RADIO_AGI_MSG_REMOVE_QUOTE;
        break;
    case OPT_UQR_ALWAYS_PROMPT:
        nSetValue = IDC_RADIO_AGI_MSG_PROMPT;
        break;
    default:
        assert(FALSE);
        break;
    }

    SetRadioButton(hDlg, nSetValue,
                   IDC_RADIO_AGI_MSG_ADD_BACKSLASH,
                   IDC_RADIO_AGI_MSG_PROMPT);

    switch(g_optionsTemp.m_nEscapedQuoteResponse)
    {
    case OPT_EQR_ALWAYS_REMOVE_BACKSLASH:
        nSetValue = IDC_RADIO_REG_TEXT_REMOVE_BACKSLASH;
        break;
    case OPT_EQR_ALWAYS_INCLUDE_BACKSLASH:
        nSetValue = IDC_RADIO_REG_TEXT_LEAVE_BACKSLASH;
        break;
    case OPT_EQR_ALWAYS_PROMPT:
        nSetValue = IDC_RADIO_REG_TEXT_PROMPT;
        break;
    default:
        assert(FALSE);
        break;
    }

    SetRadioButton(hDlg, nSetValue,
                   IDC_RADIO_REG_TEXT_REMOVE_BACKSLASH,
                   IDC_RADIO_REG_TEXT_PROMPT);
    
    return TRUE;
}

/////////////////////////////////////////////////////
//
// OnQuotesDlgWMNotify
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_NOTIFY handler for the Quotes property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_NOTIFY message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_NOTIFY message
// Parameter lParam:
//    the lParam sent with the WM_NOTIFY message
//
/////////////////////////////////////////////////////

BOOL OnQuotesDlgWMNotify(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    LPNMHDR pnmh = (LPNMHDR) lParam;
    int nSetValue;

    switch(pnmh->code)
    {
    case PSN_APPLY:
        break;

/*    case PSN_SETACTIVE:
        if (!g_bOptionsDlgCentered)
        {
            CenterDialogToParent(GetParent(hDlg));
            g_bOptionsDlgCentered = TRUE;
        }

        break;
*/
    case PSN_KILLACTIVE:
        // in the case of a PSN_KILLACTIVE, if the changes are valid,
        // call SetWindowLong and set DWL_MSGRESULT to FALSE; if invalid,
        // set it to TRUE and notify user
        nSetValue = QueryRadioButton(hDlg, IDC_RADIO_AGI_MSG_ADD_BACKSLASH,
                                     IDC_RADIO_AGI_MSG_PROMPT);
        switch(nSetValue)
        {
        case IDC_RADIO_AGI_MSG_ADD_BACKSLASH:
            g_optionsTemp.m_nUnescapedQuoteResponse =
                OPT_UQR_ALWAYS_INCLUDE_QUOTES;
            break;
        case IDC_RADIO_AGI_MSG_REMOVE_QUOTE:
            g_optionsTemp.m_nUnescapedQuoteResponse =
                OPT_UQR_ALWAYS_REMOVE_QUOTES;
            break;
        case IDC_RADIO_AGI_MSG_PROMPT:
            g_optionsTemp.m_nUnescapedQuoteResponse =
                OPT_UQR_ALWAYS_PROMPT;
            break;
        default:
            assert(FALSE);
            break;
        }

        nSetValue = QueryRadioButton(hDlg, IDC_RADIO_REG_TEXT_REMOVE_BACKSLASH,
                                     IDC_RADIO_REG_TEXT_PROMPT);

        switch(nSetValue)
        {
        case IDC_RADIO_REG_TEXT_REMOVE_BACKSLASH:
            g_optionsTemp.m_nEscapedQuoteResponse =
                OPT_EQR_ALWAYS_REMOVE_BACKSLASH;
            break;
        case IDC_RADIO_REG_TEXT_LEAVE_BACKSLASH:
            g_optionsTemp.m_nEscapedQuoteResponse =
                OPT_EQR_ALWAYS_INCLUDE_BACKSLASH;
            break;
        case IDC_RADIO_REG_TEXT_PROMPT:
            g_optionsTemp.m_nEscapedQuoteResponse =
                OPT_EQR_ALWAYS_PROMPT;
            break;
        default:
            assert(FALSE);
            break;
        }

        SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
        break;
    }

    return TRUE;
}
