/////////////////////////////////////////////////////
//
// SourceCodeDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the Soure
//    Code property page
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <cstdio>
#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "SourceCodeDlgUI.h"
#include "SourceCodeDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in OptionsDlg.cpp
extern COptions g_optionsTemp;
/////////////////////////////////////////////////////

HWND g_hwndSourceCodeDlg;

/////////////////////////////////////////////////////
//
// function prototypes
//
/////////////////////////////////////////////////////

void SourceCodeDlgGetData(HWND hDlg);

/////////////////////////////////////////////////////
//
// OnSourceCodeDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Source Code property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnSourceCodeDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_BUTTON_EDIT_DEFINES:
        return OnSourceCodeDlgButtonEditDefines();
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnSourceCodeDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Source Code property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnSourceCodeDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    HWND hwndCombo;
    char szBuffer[10];

    g_hwndSourceCodeDlg = hDlg;

    hwndCombo = GetDlgItem(hDlg, IDC_COMBO_TAB_OR_SPACE);
    ComboBoxAddString(hwndCombo, "Spaces");
    ComboBoxAddString(hwndCombo, "Tabs");
    ComboBoxSetCurSel(hwndCombo, g_optionsTemp.m_nTabsOrSpaces);

    sprintf(szBuffer, "%d", g_optionsTemp.m_nIndenterCount);
    SetWindowText(GetDlgItem(hDlg, IDC_EDIT_INDENTER_COUNT), szBuffer);

    hwndCombo = GetDlgItem(hDlg, IDC_COMBO_CURLY_BRACE_POS);
    ComboBoxAddString(hwndCombo, "next line");
    ComboBoxAddString(hwndCombo, "same line");
    ComboBoxSetCurSel(hwndCombo, g_optionsTemp.m_nCurlyBraceStyle);

    SetCheckboxChecked(hDlg, IDC_CHECK_USE_DEFINE_NAMES, 
                       g_optionsTemp.m_bUseDefineNames);
    SetCheckboxChecked(hDlg, IDC_CHECK_WRITE_TO_FILE, 
                       g_optionsTemp.m_bWriteToFile);
    SetCheckboxChecked(hDlg, IDC_CHECK_WRITE_TO_CLIPBOARD,
                       g_optionsTemp.m_bWriteToClipboard);

    SetCheckboxChecked(hDlg, IDC_CHECK_GEN_SOURCE_CODE,
                       g_optionsTemp.m_bGenerateSource);

    return TRUE;
}

/////////////////////////////////////////////////////
//
// OnSourceCodeDlgWMNotify
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_NOTIFY handler for the Source Code property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_NOTIFY message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_NOTIFY message
// Parameter lParam:
//    the lParam sent with the WM_NOTIFY message
//
/////////////////////////////////////////////////////

BOOL OnSourceCodeDlgWMNotify(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    LPNMHDR pnmh = (LPNMHDR) lParam;

    switch(pnmh->code)
    {
    case PSN_APPLY:        
        
        break;

/*    case PSN_SETACTIVE:
        if (!g_bOptionsDlgCentered)
        {
            CenterDialogToParent(GetParent(hDlg));
            g_bOptionsDlgCentered = TRUE;
        }

        break;
*/
    case PSN_KILLACTIVE:
        // in the case of a PSN_KILLACTIVE, if the changes are valid,
        // call SetWindowLong and set DWL_MSGRESULT to FALSE; if invalid,
        // set it to TRUE and notify user

        SourceCodeDlgGetData(hDlg);

        if (!g_optionsTemp.m_bWriteToClipboard &&
            !g_optionsTemp.m_bWriteToFile &&
            g_optionsTemp.m_bGenerateSource)
        {
            if (MessageBox(hDlg,
                           "The option to generate source code is\n"
                           "selected but no destination is selected.\n\n"
                           "Do you want to turn off the generation of\n"
                           "source code? (If you choose no, you must select\n"
                           "a destination for the generated source)",
                           "Question", MB_YESNO) == IDNO)
            {
                SetFocus(GetDlgItem(hDlg, IDC_CHECK_WRITE_TO_FILE));
                SetWindowLong(hDlg, DWL_MSGRESULT, TRUE);
                return TRUE;
            }
            else
            {
                SetCheckboxChecked(hDlg, IDC_CHECK_GEN_SOURCE_CODE, FALSE);
                g_optionsTemp.m_bGenerateSource = FALSE;
            }
        }

        SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
        break;
    }

    return TRUE;
}

/////////////////////////////////////////////////////
//
// SourceCodeDlgGetData
//
/////////////////////////////////////////////////////
//
// Purpose:
//    retrieves all the entries for the Source Code
//    property sheet page
// Parameter hDlg:
//    the window handle of the property sheet page
//
/////////////////////////////////////////////////////

void SourceCodeDlgGetData(HWND hDlg)
{
    char szBuffer[10];

    g_optionsTemp.m_nTabsOrSpaces =
        ComboBoxGetCurSel(hDlg, IDC_COMBO_TAB_OR_SPACE);
    GetWindowText(GetDlgItem(hDlg, IDC_EDIT_INDENTER_COUNT), szBuffer,
                  sizeof(szBuffer) - 1);
    g_optionsTemp.m_nIndenterCount = atoi(szBuffer);

    g_optionsTemp.m_nCurlyBraceStyle =
        ComboBoxGetCurSel(hDlg, IDC_COMBO_CURLY_BRACE_POS);
    g_optionsTemp.m_bUseDefineNames =
        IsCheckboxChecked(hDlg, IDC_CHECK_USE_DEFINE_NAMES);

    g_optionsTemp.m_bWriteToFile =
        IsCheckboxChecked(hDlg, IDC_CHECK_WRITE_TO_FILE);
    g_optionsTemp.m_bWriteToClipboard =
        IsCheckboxChecked(hDlg, IDC_CHECK_WRITE_TO_CLIPBOARD);

    g_optionsTemp.m_bGenerateSource =
        IsCheckboxChecked(hDlg, IDC_CHECK_GEN_SOURCE_CODE);
}