/////////////////////////////////////////////////////
//
// SourceCodeGeneration.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    function prototypes and constants relevant
//    to the generation of AGI Logic source code
//
// Portability information:
//    the code in this file should be portable
//    without much trouble
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(SOURCE_CODE_GENERATION_H_INCLUDED)
#define SOURCE_CODE_GENERATION_H_INCLUDED

// an indent string of length 30 is already absurdly huge
#define MAX_INDENT_STRING_LEN 30

// it's unlikely that even this many bytes will be generated
// (the original BLG allocated 1 million bytes, incidentally)
#define MAX_LOGIC_SRC_SIZE 250000

/////////////////////////////////////////////////////
//
// GenerateSourceFile
//
/////////////////////////////////////////////////////
//
// Purpose:
//    the main function that should be called upon to
//    generate an AGI logic source file -- takes care
//    of the details of where the logic should be written
//    based on the options that have already been set
// Parameter pszGameDir:
//    the directory where the file should be written, if
//    a file is to be written...in any case, must not be
//    NULL
//
/////////////////////////////////////////////////////

void GenerateSourceFile(PSTR pszGameDir);

#endif // !defined(SOURCE_CODE_GENERATION_H_INCLUDED)