/////////////////////////////////////////////////////
//
// SourceCodePropSheetPage.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "SourceCodeDlgEventHandlers.h"
#include "SourceCodePropSheetPage.h"

/////////////////////////////////////////////////////
//
// SourceCodePageProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    property page procedure for the Source Code property
//    page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    tell ya the truth, I don't really know what it's
//    for
//
/////////////////////////////////////////////////////

UINT CALLBACK SourceCodePageProc(HWND hwnd, UINT uiMsg, LPPROPSHEETPAGE ppsp)
{
    switch(uiMsg)
    {
    case PSPCB_CREATE:
        return TRUE;

    case PSPCB_RELEASE:
        return 0;
    }

    return 0;
}

/////////////////////////////////////////////////////
//
// SourceCodeDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Source Code property page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK SourceCodeDlgProc(HWND hDlg, UINT uiMsg, 
                                WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnSourceCodeDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnSourceCodeDlgWMInitDialog(hDlg, wParam, lParam);
    case WM_NOTIFY:
        return OnSourceCodeDlgWMNotify(hDlg, wParam, lParam);
    }

    return FALSE;
}
