//---------------------------------------------------------------------------
#include "scihdr.h"
#include "scc\scc.h"        
//---------------------------------------------------------------------------
#include "picrender.h"
//---------------------------------------------------------------------------
// Palettes
tPAL palEGA = {
	{16},
	{
    	(TColor) 0x00000000, (TColor) 0x00A00000, (TColor) 0x0000A000,
    	(TColor) 0x00A0A000, (TColor) 0x000000A0, (TColor) 0x00A00080,
    	(TColor) 0x000050A0, (TColor) 0x00A0A0A0, (TColor) 0x00505050,
    	(TColor) 0x00FF5050, (TColor) 0x0050FF00, (TColor) 0x00FFFF50,
    	(TColor) 0x005050FF, (TColor) 0x00FF50FF, (TColor) 0x0050FFFF,
    	(TColor) 0x00FFFFFF
    }
};
tPAL palEGAU = {
	{16},
	{
    	(TColor) 0x00000000, (TColor) 0x000000A0, (TColor) 0x0000A000,
    	(TColor) 0x0000A0A0, (TColor) 0x00A00000, (TColor) 0x008000A0,
    	(TColor) 0x00A05000, (TColor) 0x00A0A0A0, (TColor) 0x00505050,
    	(TColor) 0x005050FF, (TColor) 0x0000FF50, (TColor) 0x0050FFFF,
    	(TColor) 0x00FF5050, (TColor) 0x00FF50FF, (TColor) 0x00FFFF50,
    	(TColor) 0x00FFFFFF
    }
};
     
tPAL palFont = {
	{2},
	{
    	(TColor) 0x00FFFFFF, (TColor) 0x00000000
    }
};
   
tPAL palCursor = {
	{4},
	{
    	(TColor) 0x00000000,  (TColor) 0x00FFFFFF,
    	(TColor) 0x00A0A000,  (TColor) 0x00FFFFFF//0x00DCDCDC
	}
};

U8 picBackCol[sPIC_TOTALBMPS] = {15,0,0,0};

U8 rsBuf[rsMAX_SIZE];

VOCTYPES vocabTypes[] = {
    {0x000, "noword"},          // Actually exists in SCI games, discovered (11/11/00)
    {0x001, "preposition"},
    {0x002, "article"},
    {0x004, "qualifying adjective"},
    {0x008, "relative pronoun"},
    {0x010, "noun"},
    {0x020, "indicative verb"}, // (such as "is", "went" as opposed to _do_ this or that, which is imperative)
    {0x040, "adverb"},
    {0x080, "imperative verb"},
    {0x400, "conjunction"},     // "and", "or", "nor", "if", "but"
    {0x800, "subordination"},   // "until", "while", "with", "without" and "for"
    {0x4FF, "anyword"}
};
//---------------------------------------------------------------------------
BOOL SaveResourceToFile(U8 type, U16 number, U8 *buf, U16 len, U8 mode)
{
	return TRUE;
}
//---------------------------------------------------------------------------
sciVIEWLOOP *ViewFindLoopEntry(sciVIEW	*view, int e)
{
	sciVIEWLOOP *l;
	int i=0;
    l = view->firstLoop;
    while(l) {
    	if(i==e) return l;
        i++;
        l = l->next;
    }
    return NULL;
}
//---------------------------------------------------------------------------
sciVIEWCEL *ViewFindCelEntry(sciVIEWLOOP *loop, int e)
{
	sciVIEWCEL *c;
	int i=0;
    c = loop->firstCel;
    while(c) {
    	if(i==e) return c;
        i++;
        c = c->next;
    }
    return NULL;
}
//---------------------------------------------------------------------------
sciVIEWLOOP *ViewGetLoop(sciVIEW	*view, int lp)
{
	sciVIEWLOOP *l;
    l = view->firstLoop;
    while(l) {
    	if(l->loop==lp) return l;
        l = l->next;
    }
    return NULL;
}    
//---------------------------------------------------------------------------
sciVIEWLOOP *GetRealLoop(sciVIEWLOOP *loop)
{
	return(loop->mirror?loop->mirror:loop);
}
//---------------------------------------------------------------------------
sciVIEWCEL *ViewLoopGetCel(sciVIEWLOOP *loop, int cl)
{
	sciVIEWCEL *c;

    loop = GetRealLoop(loop);

    c = loop->firstCel;
    while(c) {
    	if(c->cel==cl) return c;
        c = c->next;
    }
    return NULL;
}
//---------------------------------------------------------------------------
sPOINT GetLoopMaxSize(sciVIEWLOOP *loop)
{
	int i=0;
	sPOINT p={0,0};
    sciVIEWCEL *cc = loop->firstCel;
	while(cc) {                  
		if(cc->width>p.x)  p.x=cc->width;
		if(cc->height>p.y) p.y=cc->height;
		i++;
        cc = cc->next;
	};

    return p;
}
//---------------------------------------------------------------------------
sciVIEW	*ViewLoad(U8 *buf, U16 len)
{
	sciVIEW *view;
	sciVIEWLOOP *loop=NULL,*prevLoop=NULL;
	sciVIEWCEL *cel=NULL,*prevCel=NULL;
    U16 lpMirFlags;
    U16 *lpTable,*clTable,dataLen,i,mirLp;
    U8 *ptr,col,run;

    view = (sciVIEW*)ssAlloc(sizeof(sciVIEW));

    view->totalLoops = ssBGetW(buf);
	lpMirFlags = ssBGetW(buf+2);
    // 4 bytes skipped--unknown/unused for SCI0
	lpTable = (U16*)(buf+8);

    for(U16 l=0;l<view->totalLoops;l++) {
    	// check to see if a "mirrored" loop is really mirrored with something
        // else, or just mirrored with itself
        if(l<16&&((lpMirFlags>>l)&1)) {
        	for(mirLp=0;mirLp<view->totalLoops;mirLp++) {
            	if(mirLp==l) continue;
                if(lpTable[mirLp]==lpTable[l]) { // we've found the mirror
                 	break;
                }
            }
            if(mirLp<view->totalLoops) continue;
        } else mirLp = 0;

    	// load all the non mirrored loops
        	ptr  = buf+lpTable[l];
            loop = (sciVIEWLOOP*)ssAlloc(sizeof(sciVIEWLOOP));
            if(prevLoop)
            	prevLoop->next = loop;
            else
            	view->firstLoop = loop;
          	loop->prev		= prevLoop;
            loop->next		= NULL;

            loop->mirror	= NULL;

            loop->loop		= l;
            loop->totalCels = ssBGetW(ptr);
            // skip 2 bytes unknown/unused SCI0
            clTable = (U16*)(ptr+4);

            prevCel = NULL;
            for(U16 c=0;c<loop->totalCels;c++) {
            	ptr = buf+clTable[c];
            	cel = (sciVIEWCEL*)ssAlloc(sizeof(sciVIEWCEL));
            	if(prevCel)
            		prevCel->next = cel;
            	else
            		loop->firstCel = cel;
          		cel->prev = prevCel;
            	cel->next = NULL;

                cel->loop		= l;
                cel->cel		= c;

                cel->width		= ssBGetW(ptr);
                cel->height		= ssBGetW(ptr+2);
                cel->x			= ptr[4];
                cel->y			= ptr[5];
                cel->transCol	= ptr[6];
                cel->fFlipH		= ptr[7];
                ptr += 8;

                dataLen   = (U16)(cel->width*cel->height);
            	cel->data = (U8*) ssAlloc(dataLen);

                if(mirLp) {
                	for(int y=0;y<cel->height;y++) {
                    	int x=cel->width-1;
                    	while(x>=0) {
                			run = (U8)(*ptr>>4);
                    		col = (U8)(*ptr&0xF);
                            ptr++;
                    		while(run) {
                        		cel->data[y*cel->width+x] = col;
                        		run--;
                                x--;
                    		}
                        }
                    }
                } else {  
                	i=0;
                	while(i<dataLen) {
                		run = (U8)(*ptr>>4);
                    	col = (U8)(*ptr&0xF);
                        ptr++;
                    	while(run) {
                        	cel->data[i++] = col;
                        	run--;
                    	}
                	}
                }

            	prevCel = cel;
            }

            prevLoop = loop;
    }
    for(U16 l=0;l<view->totalLoops;l++) {
    	// set up all the mirrored loops
        if(l>15||!((lpMirFlags>>l)&1)) continue;

        	for(mirLp=0;mirLp<view->totalLoops;mirLp++) {
            	if(mirLp==l) continue;
                if(lpTable[mirLp]==lpTable[l]) { // we've found the mirror
                 	break;
                }
            }
            if(mirLp==view->totalLoops) continue;

            loop = (sciVIEWLOOP*)ssAlloc(sizeof(sciVIEWLOOP));
            if(prevLoop)
            	prevLoop->next = loop;
            else
            	view->firstLoop = loop;
          	loop->prev = prevLoop;
            loop->next = NULL;

            loop->loop		= l;
            loop->mirror	= ViewGetLoop(view,mirLp);

            prevLoop = loop;
    }


	return view;
}
//---------------------------------------------------------------------------

U8 *ViewSave(sciVIEW *view, U16 *len)
{
	U8 *p,*retBuf;
	U16 *loopOffs,*celOffs;
    U16 offs=0;
    U16 mirFlags;
    sciVIEWLOOP *loop;
    sciVIEWCEL  *cel;

	loopOffs = (U16*)(rsBuf+8);

    ssBPutW((U16)view->totalLoops,(U8*)rsBuf);
	offs = (U16)((view->totalLoops*2)+8);
    mirFlags = 0;
	for(int l=0;l<view->totalLoops;l++) {
    	loop = ViewGetLoop(view,l);
        if(loop->mirror) continue;
        loopOffs[l] = offs;
    	ssBPutW((U16)loop->totalCels,(U8*)(rsBuf+(U16)offs));
        offs += (U16)4;
		celOffs  = (U16*)(rsBuf+offs);
        offs += (U16)(loop->totalCels*2);
        for(int c=0;c<loop->totalCels;c++) {
        	celOffs[c] = offs;
    		cel = ViewLoopGetCel(loop,c);
    		ssBPutW(cel->width,		rsBuf+((U16)offs));
    		ssBPutW(cel->height,	rsBuf+((U16)offs+(U16)2));
    		rsBuf[offs+4]			= cel->x;
    		rsBuf[offs+5]			= cel->y;
    		rsBuf[offs+6]			= cel->transCol;
    		rsBuf[offs+7]			= cel->fFlipH;
            offs+=(U16)8;
            p = cel->data;
            for(int y=0;y<cel->height;y++) {
            	int x=0;
                while(x<cel->width) {
                 	int run=0;
                    U8 col=*p;
                    while(p[run]==col&&run<15&&x+run<cel->width) run++;
                    rsBuf[offs++] = (U8)((run<<4)&0xF0)|(col&0xF);
                    x+=run;
                    p+=run;
                }
            }
        }
    }
        
	for(int l=0;l<view->totalLoops;l++) {
    	loop = ViewGetLoop(view,l);
        if(!loop->mirror) continue;
        loopOffs[l] = loopOffs[loop->mirror->loop];
		if(l<16) mirFlags |= (U16)(1<<l);
    }
    ssBPutW(mirFlags,(U8*)(rsBuf+(U16)2));

    *len = offs;
   	retBuf = (U8*)ssAlloc(offs);
    memcpy(retBuf,rsBuf,offs);
	return retBuf;
}
//---------------------------------------------------------------------------
void pViewDispose(sciVIEW **pView)
{
    sciVIEWLOOP *loop,*newLoop;

    if((*pView)==NULL) return;

   	loop = (*pView)->firstLoop;
    while(loop) {
   		ViewClearLoop(loop);
     	newLoop = loop->next;
        ssFree(loop);
        loop = newLoop;
    }
    ssFree(*pView);
    *pView = NULL;
}
//---------------------------------------------------------------------------
void ViewClearLoop(sciVIEWLOOP *loop)
{
    sciVIEWCEL *cel,*newCel;
    if(loop->mirror) return;
	cel = loop->firstCel;
    while(cel) {
    	ssFree(cel->data);
        newCel = cel->next;
        ssFree(cel);
        cel = newCel;
    }
}       
//---------------------------------------------------------------------------
BOOL ViewDeleteLoop(sciVIEW *view,sciVIEWLOOP *loop)
{
	sciVIEWLOOP *qloop,*al,*bl;
	sciVIEWCEL *cel;
	if(!loop||!view) return FALSE;
	int loopNum = loop->loop;

    qloop = view->firstLoop;
    while(qloop) {
     	if(qloop->mirror==loop) return FALSE;
        qloop = qloop->next;
    }
    for(int l=loopNum+1;l<view->totalLoops;l++) {
    	qloop = ViewGetLoop(view, l);
        qloop->loop--;
        if(!qloop->mirror) {
        	cel = qloop->firstCel;
            while(cel) {
            	cel->loop = qloop->loop;
                cel = cel->next;
            }
        }
    }
    if(loop->prev)
    	loop->prev->next = loop->next;
    if(loop->next)
    	loop->next->prev = loop->prev;
    view->totalLoops--;
    if(view->firstLoop==loop) {
    	if(view->totalLoops) {
        	view->firstLoop = loop->next;
        } else
        	view->firstLoop = NULL;
    }

    ViewClearLoop(loop);

    ssFree(loop);

    return TRUE;
}
//---------------------------------------------------------------------------
void ViewDeleteCel(sciVIEWLOOP *loop,sciVIEWCEL *cel)
{
	int celNum = cel->cel;
    loop = GetRealLoop(loop);
	sciVIEWCEL *qcel,*ac,*bc;
    qcel = loop->firstCel;
	while(qcel) {
		if(qcel->cel>=celNum) qcel->cel--;
		qcel = qcel->next;
	}
    if(cel->prev)
    	cel->prev->next = cel->next;
    if(cel->next)
    	cel->next->prev = cel->prev;
    loop->totalCels--;
    if(loop->firstCel==cel) {
    	if(loop->totalCels) {
        	loop->firstCel = cel->next;
        } else
        	loop->firstCel = NULL;
    }

    ssFree(cel->data);
    ssFree(cel);
}
//---------------------------------------------------------------------------
sciVIEWLOOP *ViewAddLoop(sciVIEW *view,int loopNum)
{
	sciVIEWLOOP *loop,*prevLoop;
    sciVIEWCEL *cel;
	if(loopNum==-1||loopNum>=view->totalLoops)
    	loopNum = view->totalLoops;
    else {
     	for(int l=loopNum;l<view->totalLoops;l++) {
         	loop = ViewGetLoop(view, l);
            loop->loop++;
            if(!loop->mirror) {
				cel = loop->firstCel;
    			while(cel) {
            		cel->loop = loop->loop;
        			cel = cel->next;
    			}
            }
        }
    }          
	loop = (sciVIEWLOOP*)ssAlloc(sizeof(sciVIEWLOOP));
	if(view->totalLoops) {
		prevLoop = ViewFindLoopEntry(view, view->totalLoops-1);
        prevLoop->next = loop;
	} else
		view->firstLoop = loop;
	loop->prev 			= prevLoop;
	loop->next			= NULL;

	loop->loop			= (U16)loopNum;
	loop->mirror		= NULL;
	loop->totalCels		= 0;

    view->totalLoops++;

    return loop;
}
//---------------------------------------------------------------------------
sciVIEWCEL *ViewAddCel(sciVIEWLOOP *loop,int celNum, U8 fillCol, U16 width, U16 height)
{
    sciVIEWCEL *cel,*prevCel;
    loop = GetRealLoop(loop);
	if(celNum==-1||celNum>=loop->totalCels)
    	celNum = loop->totalCels;
    else {
        	cel = loop->firstCel;
            while(cel) {
            	if(cel->cel>=celNum) cel->cel++;
                cel = cel->next;
            }
    }          
	cel = (sciVIEWCEL*)ssAlloc(sizeof(sciVIEWCEL));
    prevCel = NULL;
	if(loop->totalCels) {
		prevCel = ViewFindCelEntry(loop, loop->totalCels-1);
        prevCel->next = cel;
	} else
		loop->firstCel	= cel;
	cel->prev 			= prevCel;
	cel->next			= NULL;

	cel->loop			= loop->loop;
	cel->cel			= (U16)celNum;
    cel->width			= width;
    cel->height			= height;
                      
    cel->x				= 0;
    cel->y				= 0;
    cel->transCol		= fillCol;
    cel->fFlipH			= FALSE;

    cel->data			= (U8*)ssAlloc(width*height);
    memset(cel->data,fillCol,width*height);

	loop->totalCels++;

    return cel;
}
//---------------------------------------------------------------------------
void ViewUnmirrorLoop(sciVIEWLOOP *loop)
{
    sciVIEWCEL *cel,*newCel,*prevCel;
    int len;
    U8 *buf;

    if(!loop->mirror) return;

    loop->totalCels = loop->mirror->totalCels;
	cel = loop->mirror->firstCel;
    prevCel = NULL;
    while(cel) {
		newCel = (sciVIEWCEL*)ssAlloc(sizeof(sciVIEWCEL));
        memcpy(newCel,cel,sizeof(sciVIEWCEL));
        if(prevCel)
        	prevCel->next = newCel;
        else
			loop->firstCel = newCel;
		newCel->prev = prevCel;
		newCel->next = NULL;
		newCel->loop = loop->loop;

    	len = cel->width*cel->height;
        newCel->data = (U8*)ssAlloc(len);
        buf = cel->data;
		for(int y=0;y<cel->height;y++)
    		for(int x=cel->width-1;x>=0;x--)
        		newCel->data[y*cel->width+x] = *buf++;
        prevCel = newCel;
        cel = cel->next;
    }          
    loop->mirror = NULL;
}
//---------------------------------------------------------------------------

sciPIC *PicLoad(U8 *buf, U16 len, U8 plMODE, U8 defPal)
{
	sciPIC *pic;

    pic = (sciPIC*)ssAlloc(sizeof(sciPIC));
    pic->length = len;
    pic->data = (U8*) ssAlloc(plMODE==plEDITOR?rsMAX_SIZE:len);
	memcpy(pic->data,buf,len);
    for(int i=0;i<sPIC_TOTALBMPS;i++)
    	pic->bitmaps[i] = (U8*) ssAlloc(sPIC_SIZE);

    pic->mode = plMODE;
    pic->offset = (U16)(len-1);

	DrawPic(FALSE, defPal, pic);
    
	return pic;
}
//---------------------------------------------------------------------------
BOOL PicDraw(sciPIC *pic)
{
	DrawPic(FALSE, 0, pic);
	return TRUE;
}
//---------------------------------------------------------------------------
U8 *PicSave(sciPIC *pic, U16 *len)
{
	*len = (U16)pic->length;
	return pic->data;
}
//---------------------------------------------------------------------------
void pPicDispose(sciPIC **pPic)
{
    if((*pPic)==NULL) return;

	ssFree((*pPic)->data);
	for(int i=0;i<sPIC_TOTALBMPS;i++)
		ssFree((*pPic)->bitmaps[i]);

    ssFree(*pPic);
    *pPic = NULL;
}
//---------------------------------------------------------------------------
sciFONT *FontLoad(U8 *buf, U16 len)
{
	U16 *charOffsets;
    U8 *ptr,byt;
    sciFONTCHAR *fChar,*fLastChar;
	sciFONT *font;
    int bit,x,y;

	font = (sciFONT*) ssAlloc(sizeof(sciFONT));

	font->foo = ssBGetW(buf); // first two bytes--unknown or unused
	font->totalChars = ssBGetW(buf+2);
	font->height = ssBGetW(buf+4);
    charOffsets = (U16*)(buf+6);

    fLastChar = NULL;
    font->firstChar = NULL;
    for(int c=0;c<font->totalChars;c++) {
        if(!charOffsets[c]) continue;
        ptr = buf+charOffsets[c];

		fChar = (sciFONTCHAR*) ssAlloc(sizeof(sciFONTCHAR));
        if(!font->firstChar) font->firstChar = fChar;
        if(fLastChar)
        	fLastChar->next = fChar;
        fChar->prev = fLastChar; 
        fChar->next = NULL; 
        fChar->index = (U16)c;

        // Get the width and height
        fChar->width = *ptr;
        fChar->height = ptr[1];
        ptr += 2;

		fChar->data = (U8*)ssAlloc(fChar->width*fChar->height);
        int u=0;
        for(y = 0; y < fChar->height; y++) {
 	        x = 0;
            bit = -1;
            while(x < fChar->width) {
                if(bit == -1) {
                    byt = *ptr++;
                    bit = 7;
                }
                fChar->data[u++] = (U8)((byt >> bit) & 1);
                bit--;
                x++;
	        }
	    }
        fLastChar = fChar;
    }

	return font;
}
//---------------------------------------------------------------------------
U8 *FontSave(sciFONT *font, U16 *len)
{
	sciFONTCHAR *fChar;
	U8 *buf;
    U16 p=0;
    int x,y,bit;

    ssBPutW(font->foo,(U8*)rsBuf);
    ssBPutW(font->totalChars,(U8*)(rsBuf+2));
    ssBPutW(font->height,(U8*)(rsBuf+4));
             
	U16 *charOffsets;
    charOffsets = (U16*)(rsBuf+6);

	p = (U16)((font->totalChars<<1)+6);

    fChar = font->firstChar;
    while(fChar) {
    	charOffsets[fChar->index] = p;
        rsBuf[p  ] = fChar->width;
        rsBuf[p+1] = fChar->height;
        p+=(U16)2;

        int u=0;     
        rsBuf[p] = 0;
        for(y = 0; y < fChar->height; y++) {
 	        x = 0;
            bit = 7;
            while(x < fChar->width) {
                rsBuf[p] |= (U8)((fChar->data[u++]&1)<<bit);
                bit = (bit-1)&7;
                if(bit==7) {
                	p++;
            		rsBuf[p] = 0;
                }
                x++;
	        }
            if(bit!=7) {
            	p++;  
  				rsBuf[p] = 0;
            };
	    }
        fChar = fChar->next;
    }

    if(len) *len = p;
    buf = (U8*)ssAlloc(p);
    memcpy(buf,rsBuf,p);

	return buf;
}                                             
//---------------------------------------------------------------------------
sciFONTCHAR *GetFontChar(sciFONT *font, int index)
{
	sciFONTCHAR *fChar;   
    fChar = font->firstChar;
    while(fChar) {
    	if(fChar->index==index) return fChar;
        fChar = fChar->next;
    }
    return NULL;
}
//---------------------------------------------------------------------------
void pFontDispose(sciFONT **pFont)
{
    sciFONTCHAR *fChar,*newChar;

    if((*pFont)==NULL) return;

   	fChar = (*pFont)->firstChar;
    while(fChar) {
    	ssFree(fChar->data);
     	newChar = fChar->next;
        ssFree(fChar);
        fChar = newChar;
    }
    ssFree(*pFont);
    *pFont = NULL;
}
//---------------------------------------------------------------------------
sciCURSOR *CursorLoad(U8 *buf, U16 len)
{
	sciCURSOR *cursor;
    U8 *data;
    U16 mask1,mask2;

	cursor = (sciCURSOR *) ssAlloc(sizeof(sciCURSOR));

	cursor->hotSpot = buf[2];
	buf += 4;
    data = cursor->data;
	for(int y = 0; y < 16; y++) {
		mask1 = ssBGetW(buf);
		mask2 = ssBGetW(buf+32);
        buf += 2;
		for(int bit = 15; bit >= 0; bit--)
            *data++ = (U8)(((mask1 >> bit) & 1) << 1) | ((mask2 >> bit) & 1);
	}

	return cursor;
}
//---------------------------------------------------------------------------
U8 *CursorSave(sciCURSOR *cursor, U16 *len)
{
	U8 *buf = (U8*)ssCalloc(sCSR_FILELEN);
  	U16 *Ebuf = (U16*)(buf+4);
    *len = sCSR_FILELEN;
	buf[2] = (U8)cursor->hotSpot;
	for(int y = 0; y < 16; y++) {
		for(int x = 0; x < 16; x++) {
            Ebuf[y   ] |= (U16)((cursor->data[(y<<4)+x]>>1)&1)<<(U16)(15-x);
            Ebuf[y+16] |= (U16)(cursor->data[(y<<4)+x]&1)<<(U16)(15-x);
        }
	}

	return buf;
}
//---------------------------------------------------------------------------
void pCursorDispose(sciCURSOR **pCursor)
{
    ssFree(*pCursor);
    *pCursor = NULL;
}
//---------------------------------------------------------------------------
     
//---------------------------------------------------------------------------
// fill a memo with information about a given script
void GetScriptInfo(U8 *ScrData, U16 Len,TMemo *Memo)
{
    Memo->Lines->Clear();
    Memo->Visible = false;

    U16 Offs = 0,TotalSegments=0,Segment,SegLen,SegEnd,NameAddr;
    char *Str;
    Memo->Lines->Add("Script Information");
    Memo->Lines->Add("");
    while(Offs<Len) {
        Segment = ssBGetW(ScrData+Offs);
        if(Segment==sgRETURN) break;
        Offs += ssBGetW(ScrData+Offs+2);
        TotalSegments++;
    }
    Offs = 0;
    Memo->Lines->Add("Total Segments: "+IntToStr(TotalSegments));
    while(Offs<Len) {
        Segment = ssBGetW(ScrData+Offs);

        if(Segment==sgRETURN) break;

        SegLen = ssBGetW(ScrData+Offs+2);
        SegEnd = Offs+SegLen;
        switch(Segment) {
            case sgLOCAL:
                Memo->Lines->Add("Total Locals: "+IntToStr((SegLen>>1)-4));
                break;
            case sgPUBLIC:
                Memo->Lines->Add("Total Public: "+IntToStr(ssBGetW(ScrData+Offs+4)));
                break;
            case sgRELOCATION:
                Memo->Lines->Add("Total Relocation: "+IntToStr(ssBGetW(ScrData+Offs+4)));
                break;
            case sgCLASS:
                NameAddr = ssBGetW(ScrData+Offs+18);
                Memo->Lines->Add("Class: "+AnsiString((char*)(ScrData+NameAddr)));
                break;
            case sgINSTANCE:
                NameAddr = ssBGetW(ScrData+Offs+18);
                Memo->Lines->Add("Instance: "+AnsiString((char*)(ScrData+NameAddr)));
                break;
            case sgSTRINGS:
                NameAddr = Offs+4;
                Memo->Lines->Add("Strings: ");
                while(NameAddr < SegEnd) {
                    Str = (char*)(ScrData+NameAddr);
                    Memo->Lines->Add("\t\""+AnsiString(Str)+"\"");
                    NameAddr += strlen(Str)+1;
                }
                break;
        }
        Offs = SegEnd;
    }

    Memo->Visible = true;
}
//---------------------------------------------------------------------------
AnsiString GetVocTypeName(int Mask)
{         int i;

    for(i = 0; i < 12; i++)
        if(vocabTypes[i].Mask == Mask){//ShowMessage(AnsiString(vocabTypes[i].Name));
            return vocabTypes[i].Name; }

    return "NULL";
}
//---------------------------------------------------------------------------
AnsiString GetVocabTypesAsString(WORD Type)
{
    AnsiString Str = "";

    switch(Type) {
        case 0: // no word
            Str = GetVocTypeName(vtNO_WORD);
            break;
        case 0x4FF:
            Str = GetVocTypeName(vtANY_WORD);
            break;
        default:
            for(int i = 0; i < TOTAL_VT; i++)
                if((Type >> i) & 1) {
                    if(Str != "") Str += " | ";
                    Str += GetVocTypeName(1 << i);
                }
    }

    return Str;
}

//---------------------------------------------------------------------------
void DecodeVocab(U8 *Data, int Num, U16 FileLen, TMemo *Memo)
{
	AnsiString s;
	char VocString[128],str1[41],str2[41];
	int Offset,Count,type1,type2,strSegs,segLen,segEnd;
                int i,j,k,l;
    Memo->Lines->Clear();
    Memo->Visible = false;

    Memo->Lines->Add("Vocab Information"); 
    Memo->Lines->Add("");
    switch(Num) {
    	case 0:
    		Memo->Lines->Add("Type: Words");
   			Memo->Lines->Add("");
			Offset = 52;
   			while(Offset < FileLen) {
        		i = Data[Offset++];
        		while((BYTE) (VocString[i++] = Data[Offset++]) < 0x80);
        		VocString[i-1] &= 0x7F;
        		VocString[i] = '\0';
        		Offset += 3;
   				Memo->Lines->Add(AnsiString(VocString));
            }
            break;
    	case 901:
    		Memo->Lines->Add("Type: Suffixes");
            Offset = 0;
   			Memo->Lines->Add("");
   			while(Offset<FileLen) {
            	strcpy(str1, (char*)(Data+Offset));
                Offset += strlen(str1)+1;
                type1 = Data[Offset]+(Data[Offset+1]<<8);
                Offset+=2;
            	strcpy(str2, (char*)(Data+Offset));
                Offset += strlen(str2)+1;
                type2 = Data[Offset]+(Data[Offset+1]<<8);
                Offset+=2;

            	s.sprintf("\"%s\" of (%s) -> \"%s\" of (%s)", str1, GetVocabTypesAsString(type1).c_str(), str2, GetVocabTypesAsString(type2).c_str());
   				Memo->Lines->Add(s);
            }
            break;
    	case 995:
    		Memo->Lines->Add("Type: Debug Info");
            Offset = 0;
            strSegs = Data[Offset]+(Data[Offset+1]<<8);
   			Memo->Lines->Add("String Segments: "+IntToStr(strSegs));
            j=0;
   			while(j<strSegs) {                 
            	Offset = Data[(j<<1)+2]+(Data[(j<<1)+3]<<8);
                                           
                segLen = Data[Offset]+(Data[Offset+1]<<8);
                Offset += 2;
                segEnd = Offset+segLen;

   				Memo->Lines->Add("");
   				Memo->Lines->Add("");
   				Memo->Lines->Add("Segment #"+IntToStr(j));
   				Memo->Lines->Add("Length: "+IntToStr(segLen)); 
   				Memo->Lines->Add("");

                while(Offset<segEnd) {
                	k=0;
                 	for(l=Offset;Data[l]!='\n'&&l<segEnd;l++) {
                    	VocString[k]=Data[l];
                        k++;
                    }
                    VocString[k]='\0';
            		Memo->Lines->Add(AnsiString(VocString));
                    Offset = l+1;
                }
                j++;
            }
            break;
    	case 996:
    		Memo->Lines->Add("Type: Class Table");
            Offset = 0;
            Count = FileLen>>2;
   			Memo->Lines->Add("Total Classes: "+IntToStr(Count));
   			Memo->Lines->Add("");
            j = 0;
   			while(j<Count) {
            	s.sprintf("Class #%d is in SCRIPT.%03d", j, Data[Offset+2]+(Data[Offset+3]<<8));
   				Memo->Lines->Add(s);
                j++;
                Offset+=4;
            }
            break;
    	case 997:
    		Memo->Lines->Add("Type: Selector Names");
            Offset = 0;
            Count = Data[Offset]+(Data[Offset+1]<<8)+1;
   			Memo->Lines->Add("Total Selectors: "+IntToStr(Count));
   			Memo->Lines->Add("");
            j = 0;
   			while(j<Count) {
				Offset = Data[(j<<1)+2]+(Data[(j<<1)+3]<<8);
        		BYTE StrLen = Data[Offset];
                Offset+=2;
        		for(i=0;i<StrLen;i++) VocString[i] = Data[Offset++];
        		VocString[i] = '\0';
   				Memo->Lines->Add(IntToStr(j)+": "+AnsiString(VocString));
                j++;
            }
            break;
    	case 998:
    		Memo->Lines->Add("Type: Opcode Names");
            Offset = 0;
            Count = Data[Offset]+(Data[Offset+1]<<8)-1;
   			Memo->Lines->Add("Total Opcodes: "+IntToStr(Count));
   			Memo->Lines->Add("");
            j = 0;
   			while(j<Count) {
				Offset = Data[(j<<1)+2]+(Data[(j<<1)+3]<<8);
        		BYTE StrLen = Data[Offset]-2;
        		BYTE Params = Data[Offset+2]+(Data[Offset+3]<<8);
                Offset+=4;
        		for(i=0;i<StrLen;i++) VocString[i] = Data[Offset++];  
        		while(i<9) VocString[i++] = ' ';
        		VocString[i] = '\0';
   				Memo->Lines->Add(IntToHex(j,2)+": "+AnsiString(VocString)+" \t"+IntToStr(Params));   
                j++;
            }
            break;
    	case 999:
    		Memo->Lines->Add("Type: Kernel Names");
            Offset = 0;
            Count = Data[Offset]+(Data[Offset+1]<<8);
   			Memo->Lines->Add("Total Kernels: "+IntToStr(Count));
   			Memo->Lines->Add("");
            j = 0;
   			while(j<Count) {
				Offset = Data[(j<<1)+2]+(Data[(j<<1)+3]<<8);
        		BYTE StrLen = Data[Offset];
                Offset+=2;
        		for(i=0;i<StrLen;i++) VocString[i] = Data[Offset++];
        		VocString[i] = '\0';
                //if(!FileExists("D:\\programming\\SCIStudio\\Help\\SCC\\kernel_"+AnsiString(VocString)+".html")) {
   					Memo->Lines->Add(AnsiString(VocString));
                //}
                j++;
            }
            break;
        default:   
    		Memo->Lines->Add("Unsupported vocab resource!");
    }


    Memo->Visible = true;
}
//---------------------------------------------------------------------------
void TextToMemo(U8 *Data,U16 Len,TMemo *Memo)
{
    Memo->Lines->Clear();
    Memo->Visible = false;

    WORD Offs = 0,Num=0,StrLen;

    while(Offs<Len) {
        StrLen = strlen((char*)(Data+Offs));
        Memo->Lines->Add(IntToStr(Num)+": "+AnsiString((char*)(Data+Offs)));
        Offs+=StrLen+1;
        Num++;
    }

    Memo->Visible = true;
}
//---------------------------------------------------------------------------
