/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#include "StdAfx.h"
#include "soundresource.h"
#include "SoundPlayer.h"
#include "MidiPlayer.h"
#include "Exception.h"
#include <mmsystem.h>

MidiPlayer::MidiPlayer(HWND listener)
: RealtimePlayer(listener), mMidiOut(0)
{
}

MidiPlayer::~MidiPlayer()
{
}

void MidiPlayer::OpenDevice(DataStream *patch)
{
	// open a MIDI out handle for the MIDI mapper that we can stream messages to
	if (midiOutOpen(&mMidiOut, MIDI_MAPPER, 0, 0, CALLBACK_NULL) != MMSYSERR_NOERROR) {
		throw DeviceException("Could not open MIDI mapper for output");
	}
}

void MidiPlayer::CloseDevice()
{
	// close our MIDI out handle
	midiOutClose(mMidiOut);
	mMidiOut = 0;
}

void MidiPlayer::HandleEvent(const sound_event &event)
{
	// just send the message to the MIDI mapper
	midiOutShortMsg(mMidiOut,
		((event.status | event.channel) & 0xFF) |
		((event.param1 & 0x7F) << 8) |
		((event.param2 & 0x7F) << 16));
}

void MidiPlayer::MapChannelVoices(int channel, int numVoices)
{
	// no need to handle voice controls
}
